function SX = spettrogramma(x, Fc, Nw, L, M, tipo)
%SX = spettrogramma(x, Fc, Nw, L, M, tipo)
% Calcola e mostra in una figura lo spettrogramma del segnale x
% Fc - frequenza di campionamento di x in Hz
% Nw - durata della finestra di analisi (numero campioni)
% L - intervallo tra due finestre consecutive (numero di campioni)
% M - parametro di zero padding
% tipo - nome della finestra (stringa): 'rect' o 'hamming'
%
% (C) Marco Cagnazzo, Università di Padova, 2024-2025


% Inizializzazioni
Tc = 1/Fc;  winPeriod = L*Tc; Nx =numel(x);
% Creazione della finestra
switch lower(tipo)
    case 'hamming'
        w =  0.54- 0.46*cos(2*pi*(1:Nw)/Nw);
    otherwise % Default: rect
        w = ones(1,Nw);
end
nFreq = M/2; % nr campioni frequenza: solo frequenze positive
nTimes = ceil((Nx-Nw)/L); % nr campioni tempo dello spettrogramma
SX = zeros(nFreq,nTimes);
% Ciclo sulle diverse finestre temporali
for n = 0: L : Nx-Nw
    y = x(n+1:n+Nw) .* w(:); % "Finestratura" del segnale
    Y = Tc * fft(y,M); % Calcolo campioni TF
    SX(1:M/2, n/L+1 ) = 10*log10(abs(Y(1:M/2)).^2);
end
% Comandi per la corretta visualizzazione
timeAxis = [winPeriod/2 winPeriod*(nTimes-1/2)]  * 1000;
freqAxis = [Fc/(2*M),  Fc/2 - Fc/(2*M)];
% Creazione figura
figure;  imagesc(timeAxis,freqAxis, SX); 
c = colorbar; c.Label.String = 'dB';
xlabel('Time - ms'); ylabel('Frequency - Hz');



