%% Illustrazione della risoluzione in frequenza delle finestre di analisi

N = 1e3;   %  Numero campioni del segnale
M = 2^13;  % Ordine FFT (zero-padding)
n = 0:N-1; % Indici del segnale t.d.
f1 = 1e3;  % Frequenza prima sinusoide
DF = 60;   % Differenza di frequenze
f2 = f1+DF;% Frequenza seconda sinusoide
FC = 3e3;  % Frequenza di campionamento
TC = 1/FC; % Periodo di campionamento


Nw = 100;  % Durata finestra di analisi

%% Primo esperimento: segnali di ampiezza uguale

x1 = cos(2*pi*f1*n*TC); % Segnale x1
x2 = cos(2*pi*f2*n*TC); % Segnale x2 

figure(1);

%% Finestra rect
w = ones(1,Nw);
x1w  = x1(1:Nw).*w;  % Finestra di osservazione
x2w  = x2(1:Nw).*w;  
xs   = x1w+x2w;      % Segnale somma
X1W = abs(fftshift(fft(x1w,M))); % Spettri di ampiezza osservati
X2W = abs(fftshift(fft(x2w,M)));
XS  = abs(fftshift(fft(xs,M)));

freq = -FC/2:(FC/M):(FC/2-FC/M); % Asse frequenze
subplot(211); title('rect')
plot(freq,X1W, 'k--', freq,X2W, 'b--', freq, XS, 'r-','LineWidth',2);
xlim([f1-100, f2+100]) % Zoom sulle frequenze di interesse
legend('|X1|','|X2|', '|X1+X2|');  xlabel('f - Hz')

title(sprintf('f_1=%d f_2=%d',f1,f2))

%% Finestra di Hamming

w =  0.54- 0.46*cos(2*pi*(1:Nw)/Nw);
x1w  = x1(1:Nw).*w;
x2w  = x2(1:Nw).*w;
xs   = x1w+x2w;
X1W = abs(fftshift(fft(x1w,M)));
X2W = abs(fftshift(fft(x2w,M)));
XS  = abs(fftshift(fft(xs,M)));

freq = -FC/2:(FC/M):(FC/2-FC/M);
subplot(212); 
plot(freq,X1W, 'k--', freq,X2W, 'b--', freq, XS, 'r-','LineWidth',2);
legend('|X1|','|X2|', '|X1+X2|'); xlabel('f - Hz')
xlim([f1-100, f2+100]) 

%% Sinusoidi di ampiezza diversa
attenuazione = 1/10;
DF = 120;  % Prendiamo sinusoidi risolvibili con la finestra di Hamming
f2 = f1+DF;

x1 = cos(2*pi*f1*n*TC); 
x2 = cos(2*pi*f2*n*TC)*attenuazione; 

figure(2);


%% Finestra rect
w = ones(1,Nw);
x1w  = x1(1:Nw).*w;
x2w  = x2(1:Nw).*w;
xs   = x1w+x2w;
X1W = abs(fftshift(fft(x1w,M)));
X2W = abs(fftshift(fft(x2w,M)));
XS  = abs(fftshift(fft(xs,M)));

freq = -FC/2:(FC/M):(FC/2-FC/M);
subplot(211); title('rect')
plot(freq,X1W, 'k--', freq,X2W, 'b--', freq, XS, 'r-','LineWidth',2);
xlim([f1-100, f2+100]) 
legend('|X1|','|X2|', '|X1+X2|');  xlabel('f - Hz')
text(f2-80,15,'Seconda sinusoide mascherata')

title(sprintf('f_1=%d f_2=%d',f1,f2))

%% Finestra di Hamming

w =  0.54- 0.46*cos(2*pi*(1:Nw)/Nw);
x1w  = x1(1:Nw).*w;
x2w  = x2(1:Nw).*w;
xs   = x1w+x2w;
X1W = abs(fftshift(fft(x1w,M)));
X2W = abs(fftshift(fft(x2w,M)));
XS  = abs(fftshift(fft(xs,M)));

freq = -FC/2:(FC/M):(FC/2-FC/M);
subplot(212); 
plot(freq,X1W, 'k--', freq,X2W, 'b--', freq, XS, 'r-','LineWidth',2);
legend('|X1|','|X2|', '|X1+X2|'); xlabel('f - Hz')
xlim([f1-100, f2+100]) 
text(f2-80,10,'Si riesce a vedere la seconda sinusoide')


