clc; clearvars; close all; 
% Un segnale a tempo discreto e supporto 0 ... N-1
N=8; n = 0:(N-1); xMatlab = sqrt(n);
figure; subplot(311); stem (n,xMatlab); 
legend('x(n)','Location','northwest')
% TFD con zero-padding
M=2^6; 
ZMatlab = fft(xMatlab,M); % Effettua zero-padding e DFT
subplot(312); stem(0:M-1,abs(ZMatlab),'r'); 
xlabel('k'); ylabel('|Z_{TFD}(k)|'); axis([0 M 0 15])
legend(sprintf('TFD con zero padding, M=%d',M),'Location','north');
% Usiamo la TFD come campionamento della TFtd
subplot(313);
omega1 = 2*pi/M; w = -pi:omega1: pi-omega1;
stem(w, fftshift(abs(ZMatlab)),'r'); 
%title('Riposizionamento del grafico')
xlabel('\omega'); ylabel('|X(k \omega_1)|');
% Questi comandi correggono la visualizzazione dell'asse delle ascisse
axis([-pi pi 0 15])
set(gca,'XTick', [-pi, -3*pi/4 -pi/2, -pi/4, 0, pi/4, pi/2, 3*pi/4, pi])
set(gca,'XTickLabel', {'-\pi', '-3\pi/4', '-\pi/2', '-\pi/4', '0',...
    '\pi/4', '\pi/2', '3\pi/4' , '\pi'})
