from docplex.mp.model import Model
from random import random
import time

#create random data for given number of origins and destinations
num_origins = int(input("Number of origins ? "))
num_destinations = int(input("Number of destinations ? "))
I=range(0,num_origins)
J=range(0,num_destinations)
cost = [[int(random()*10)+0.5 for j in J] for i in I]
origin_capacity = [int(random()*100) for i in I]
destination_request = [int(random()*100) for j in J]
origin_capacity[0] += max(0,sum(destination_request) - sum(origin_capacity))
#print(origin_capacity)
#print(destination_request)
#we decide to remove expensive Origin-Destinatio links (less variables will be created)
cost_threshold = float(input("consider links with cost up to [0..10] ? "))

time1 = time.time()
print("creating origin-destination pairs...\n", end='', flush=True)
ODpairs = [(i, j) for i in I for j in J if cost[i][j] <= cost_threshold]
print("creating model environment...\n", end='', flush=True)
m = Model(name="transportation with OD pairs")
print("creating decision variables...\n", end='', flush=True)
timev1 = time.time()
mode = 2
if mode == 1:
    ## custom list 1: all vars at once, then map
    x = m.continuous_var_list(keys=len(ODpairs), name = "x")
    # we assume that variables in position x[p] corresponds to the ODpair[p], that is
    #  x[p] is the variable x_ij, where (i,j) == ODpairs[p]
    #  we create a map to directly transform (i,j) into p so as to map x_ij into x[p] (given (i,j) in ODpairs)
    # map_x[i][j] will be the position of variable x_ij in the list of variables, -1 if x_ij does not exist
    map_x = [[-1 for j in J] for i in I]
    for p in range(len(ODpairs)):
        (i,j) = ODpairs[p] 
        map_x[i][j] = p #position of x_ij var
else:
    ### custom list 2: var and mapping one at a time - SENSIBLY SLOWER!
    map_x = [[-1 for j in J] for i in I]
    position_of_ijvar = 0
    x=[]
    for p in range(len(ODpairs)):
        (i,j) = ODpairs[p] 
        x.append(m.continuous_var(name="x_"+format(i)+"_"+format(j)))
        map_x[i][j] = position_of_ijvar
        position_of_ijvar += 1
timev2 = time.time()
print("\nTOTAL time to create variable custom list: ",timev2-timev1)
print("creating objective function...\n", end='', flush=True)
#m.minimize(m.sum(cost[i][j] * x[i*num_destinations+j] for i in I for j in J))
m.minimize(m.sum(cost[ODpairs[p][0]][ODpairs[p][1]] * x[p] for p in range(len(ODpairs))))
print("creating constraints destinations...", end='', flush=True)
c=[]
for j in J:
    if (j % 100 == 0):
        print(j," ", end='', flush=True)
    #m.add_constraint(m.sum(x[map_x[i][j]] for i in I if map_x[i][j] >= 0) >= destination_request[j])
    c.append(m.sum(x[map_x[i][j]] for i in I if map_x[i][j] >= 0) >= destination_request[j])
print("\ncreating constraints origins...", end='', flush=True)
for i in I:
    if (i % 100 == 0):
        print(i," ", end='', flush=True)
    #m.add_constraint(m.sum(x[map_x[i][j]] for j in J if map_x[i][j] >= 0) <= origin_capacity[i] )
    c.append(m.sum(x[map_x[i][j]] for j in J if map_x[i][j] >= 0) <= origin_capacity[i] )
print("\nadding constraints...", end='', flush=True)
m.add_constraints(c)
time2 = time.time()
print("\nTOTAL time to create the model: ",time2-time1)

m.print_information()
#m.export_as_lp(path=".")
input("type to continue")
time1 = time.time()
sol = m.solve(log_output = True)
time2 = time.time()
print("\nTime to solve the model: ",time2-time1)
if sol:
    print("objective function: ",m.objective_value)
else:
    print("The model is infeasible: with the generated data, the selected threshold is too small.")
