from docplex.mp.model import Model
from random import random
import time

#create random data for given number of origins and destinations
num_origins = int(input("Number of origins ? "))
num_destinations = int(input("Number of destinations ? "))
I=range(0,num_origins)
J=range(0,num_destinations)
cost = [[int(random()*10)+0.5 for j in J] for i in I]
origin_capacity = [int(random()*100) for i in I]
destination_request = [int(random()*100) for j in J]
origin_capacity[0] += max(0,sum(destination_request) - sum(origin_capacity))
#print(origin_capacity)
#print(destination_request)

time1 = time.time()
print("creating model environment...\n", end='', flush=True)
m = Model(name="transportation with OD pairs")
print("creating decision variables...\n", end='', flush=True)
timev1 = time.time()
x = m.continuous_var_list(keys=num_origins*num_destinations, name = "y")
# we assume that x "linearizes" the matrix with I x J elements, that is,
#  variable x_ij is the one in position x[i * num_destinations + j]
timev2 = time.time()
print("\nTOTAL time to create variable complete list: ",timev2-timev1)
print("creating objective function...\n", end='', flush=True)
m.minimize(m.sum(cost[i][j] * x[i*num_destinations+j] for i in I for j in J))
print("creating constraints destinations...", end='', flush=True)
for j in J:
    if (j % 100 == 0):
        print(j," ", end='', flush=True)
    m.add_constraint(m.sum(x[i*num_destinations+j] for i in I) >= destination_request[j])
print("\ncreating constraints origins...", end='', flush=True)
for i in I:
    if (i % 100 == 0):
        print(i," ", end='', flush=True)
    m.add_constraint(m.sum(x[i*num_destinations+j] for j in J) <= origin_capacity[i] )
time2 = time.time()
print("\nTOTAL time to create the model: ",time2-time1)

m.print_information()
input("type to continue")
time1 = time.time()
sol = m.solve(log_output = True)
time2 = time.time()
print("\nTime to solve the model: ",time2-time1)
if sol:
    print("objective function: ",m.objective_value)
else:
    print("The model is infeasible: with the generated data, the selected threshold is too small.")
