from docplex.mp.model import Model
from random import random
import time

#create random data for given number of origins and destinations
num_origins = int(input("Number of origins ? "))
num_destinations = int(input("Number of destinations ? "))
I=range(0,num_origins)
J=range(0,num_destinations)
cost = [[int(random()*10)+0.5 for j in J] for i in I]
##cost = {(i,j): random()*10 + 0.5 for i in I for j in J}
origin_capacity = [int(random()*100) for i in I]
destination_request = [int(random()*100) for j in J]
origin_capacity[0] += max(0,sum(destination_request) - sum(origin_capacity))
#print(origin_capacity)
#print(destination_request)
#we decide to remove expensive Origin-Destinatio links (less variables will be created)
cost_threshold = float(input("consider links with cost up to [0..10] ? "))

time1 = time.time()
print("creating origin-destination pairs...\n", end='', flush=True)
ODpairs = [(i, j) for i in I for j in J if cost[i][j] <= cost_threshold]
timev1 = time.time()
print("creating model environment...\n", end='', flush=True)
m = Model(name="transportation with OD pairs")
print("creating decision variables...\n", end='', flush=True)
x = m.continuous_var_dict(keys=ODpairs, lb={od: 0 for od in ODpairs}, name = "x")
timev2 = time.time()
print("\nTOTAL time to create variable dict: ",timev2-timev1)
print("creating objective function...\n", end='', flush=True)
m.minimize(m.sum(cost[od[0]][od[1]] * x[od] for od in ODpairs))
print("creating constraints destinations...", end='', flush=True)
for j in J:
    if (j % 100 == 0):
        print(j," ", end='', flush=True)
    m.add_constraint(m.sum(x[od] for od in ODpairs if od[1] == j) >= destination_request[j])
print("\ncreating constraints origins...", end='', flush=True)
for i in I:
    if (i % 100 == 0):
        print(i," ", end='', flush=True)
    m.add_constraint(m.sum(x[od] for od in ODpairs if od[0] == i) <= origin_capacity[i] )
time2 = time.time()
print("\nTOTAL time to create the model: ",time2-time1)

m.print_information()
input("type to continue")
time1 = time.time()
sol = m.solve(log_output = True)
time2 = time.time()
print("\nTime to solve the model: ",time2-time1)
if sol:
    print("objective function: ",m.objective_value)
else:
    print("The model is infeasible: with the generated data, the selected threshold is too small.")
