from docplex.mp.model import Model

# MOVING SCAFFOLDS

# data: sets
I = ['A','B','C'] # set of closing sites
J= [1,2,3] # set of new sites

# data: problem parameteres 
D = {} # numer of rods available at each origin
d_list = [7000,6000,4000] # ORDERED list of the rods at each origin
for i in range(len(I)): #put in a dictionary for ease of reference
    D[I[i]] = d_list[i]
R ={} # number of rods required at each destination
r_list = [8000,5000,4000] # ORDERED list of the rods request at each destination
for j in range(len(J)):
    R[J[j]] = r_list[j]
C = {} # transport cost of a unit from origin i to destination j (in euro)
c_matrix = [[9,6,5],[7,4,9],[4,6,3]] #in eurocents
for i in range(len(I)):
    for j in range(len(J)):
        C[(I[i],J[j])] = 0.01*c_matrix[i][j]
N = 4 # number of available trucks
F = 50 # fixed cost for each truck (euros)
K = 10000 # trucks capacity
L = 65 # fixed cost for the rent of an additional truck (euros)
exclusiveSupply = [(2,['A','B'])] #we generalize with a set of pairs (d,X), where a is d destination and X is a list of nutually exclusive alternatives 

#MODEL CREATION
version = "basic" #"basic" or "variant1" or "variant2"
if version == "basic":
 m = Model(name = "moving scaffolds basic")
 x = m.integer_var_matrix(keys1 = I,keys2 = J,lb = 0, ub = None, name = 'x')
 y = m.binary_var_matrix(keys1 = I,keys2 = J, name = 'y')
 z = m.binary_var(name ='z')

 m.minimize(m.sum(C[(i,j)]*x[(i,j)] + F*y[(i,j)] for i in I for j in J) + (L-F)*z)

 m.add_constraints(m.sum(x[(i,j)] for i in I)>= R[j] for j in J)
 m.add_constraints(m.sum(x[(i,j)] for j in J)<= D[i] for i in I)
 m.add_constraints(x[(i,j)] <= K*y[(i,j)] for i in I for j in J)
 m.add_constraint(m.sum(y[(i,j)] for i in I for j in J) <= N+z)
 m.add_constraints(sum( y[i,d] for i in X) <= 1 for (d,X) in exclusiveSupply)

elif version == "variant1":
 m = Model(name = "moving scaffolds v1")
 x = m.integer_var_matrix(keys1 = I,keys2 = J,lb = 0, ub = None, name = 'x')
 w = m.integer_var_matrix(keys1 = I,keys2 = J,lb = 0, ub = None, name = 'w') #new var
 y = m.binary_var_matrix(keys1 = I,keys2 = J, name = 'y')
 z = m.integer_var(lb = 0, ub = None, name ='z') #domain change
 
 m.minimize(m.sum(C[(i,j)]*x[(i,j)] + F*w[(i,j)] for i in I for j in J) + (L-F)*z)
 
 m.add_constraints(m.sum(x[(i,j)] for i in I)>= R[j] for j in J)
 m.add_constraints(m.sum(x[(i,j)] for j in J)<= D[i] for i in I)
 m.add_constraints(x[(i,j)] <= K*w[(i,j)] for i in I for j in J) #new var
 m.add_constraint(m.sum(w[(i,j)] for i in I for j in J) <= N+z) #new var
 bigM = D #D[i] is an upper bound on x[(i,j)], for every j
 m.add_constraints(x[(i,j)] <= bigM[i]*y[(i,j)] for i in I for j in J) #new bigM
 m.add_constraints(sum( y[i,d] for i in X) <= 1 for (d,X) in exclusiveSupply)

elif version == "variant2":
 A = {} # fixed costs for moving something from origin i in I
 a_list = [100,150,175] # ORDERED list of the fixed costs at each origin
 for i in range(len(I)):
    A[I[i]] = a_list[i]
 m = Model(name = "moving scaffolds v2")
 x = m.integer_var_matrix(keys1 = I,keys2 = J,lb = 0, ub = None, name = 'x')
 w = m.integer_var_matrix(keys1 = I,keys2 = J,lb = 0, ub = None, name = 'w')
 y = m.binary_var_matrix(keys1 = I,keys2 = J, name = 'y')
 z = m.integer_var(lb = 0, ub = None, name ='z')
 v = m.binary_var_dict(keys = I , name = 'v') #new var
 
 m.minimize(m.sum(C[(i,j)]*x[(i,j)] + F*w[(i,j)] for i in I for j in J) + (L-F)*z + sum(A[i]*v[i] for i in I)) #new component
 
 m.add_constraints(m.sum(x[(i,j)] for i in I)>= R[j] for j in J)
 m.add_constraints(m.sum(x[(i,j)] for j in J)<= D[i] * v[i] for i in I) #also sets new var
 m.add_constraints(x[(i,j)] <= K*w[(i,j)] for i in I for j in J)
 m.add_constraint(m.sum(w[(i,j)] for i in I for j in J) <= N+z)
 bigM = D #D[i] is an upper bound on x[(i,j)], for every j
 m.add_constraints(x[(i,j)] <= bigM[i]*y[(i,j)] for i in I for j in J)
 m.add_constraints(sum( y[i,d] for i in X) <= 1 for (d,X) in exclusiveSupply)

m.print_information() #display information on the model 
m.export_as_lp(path = '.')

if m.solve():
    m.print_solution()    #display information on the solution
    m.solution.export('moving_scaffolds_'+version+'_solution.json') # exports solution in a json file
else:
    print(m.get_solve_status())