from docplex.mp.model import Model

# ANTENNAS LOCATION

# data: sets
I = ['A','B','C','D','E'] # set of sites for antennas location
J= [1,2,3,4,5,6] # set of areas to cover
bridge_pairs = [('E','D')]
# data: problem parameters 
T = 18 # minimum signal required
N = 2 # maximum number of non-interfering signals
S = {} # signal intensity from antenna i to area j
s_matrix = [[10,20,16,25,0,10],[0,12,18,23,11,6],[21,8,5,6,23,19],[16,15,15,8,14,18],[21,13,13,17,18,22]]
for i in range(len(I)):
    for j in range(len(J)):
        S[(I[i],J[j])] = s_matrix[i][j]

# model parameters
M ={j: len([i for i in I if S[(i,j)] >= T]) - N for j in J} # large enough "big-M" parameter
#M ={} # large enough parameter
#for j in J:
#    s_j = []
#    for item in s_matrix:
#        s_j.append(item[J.index(j)])
#    M[j] = len([s for s in s_j if s >= T])

# MODEL CREATION
m = Model(name = "antennas")

x = m.binary_var_dict(keys = I, name = 'x')
z = m.binary_var_dict(keys = J, name = 'z')

m.maximize(m.sum(z[j] for j in J))

for j in J:
    m.add_constraint(m.sum(x[i] for i in I if S[(i,j)] >= T) >= z[j], ctname='covering zone %d' %j)
    m.add_constraint(m.sum(x[i] for i in I if S[(i,j)] >= T) <= N + M[j]*(1-z[j]), ctname= 'non interfering in zone %d' % j)

m.add_constraints(x[b[0]]<=x[b[1]] for b in bridge_pairs)

m.print_information() #display information on the model 
m.export_as_lp(basename='antennas', path = '.') 

if m.solve():
    m.print_solution()    #display information on the solution
    m.solution.export('antennas_solution.json') # exports solution in a json file
else:
    print(m.get_solve_status())