param probScen1 := 0.4;
param probScen2 := 0.4;
param probScen3 := 1 - probScen1 - probScen2;
param bigM := 1000;

param probMin := 0.5;

var xL >= 0; #numero ettari a lattughe
var xP >= 0; #numero ettari a patate
var z1 binary; #vale 1 se soddisfo scenario 1, 0 altrimenti
var z2 binary; #vale 1 se soddisfo scenario 2, 0 altrimenti
var z3 binary; #vale 1 se soddisfo scenario 3, 0 altrimenti

maximize fo: 3000 * xL + 5000 * xP;

s.t. ettari_disponibili: xL + xP <= 11;
s.t. semi_disponibili: 7 * xL <= 70;

s.t. scen1_tuberi_disponibili: 3 * xP <= 18 + 1000*(1-z1);
s.t. scen1_concime_disponibile: 10 * xL + 20 * xP <= 145 + 1000*(1-z1);

s.t. scen2_tuberi_disponibili: 3 * xP <= 16 + 1000*(1-z2);
s.t. scen2_concime_disponibile: 10 * xL + 20 * xP <= 165 + 1000*(1-z2);

s.t. scen3_tuberi_disponibili: 3 * xP <= 25 + 1000*(1-z3);
s.t. scen3_concime_disponibile: 10 * xL + 20 * xP <= 125 + 1000*(1-z3);

s.t. robustezza: probScen1*z1 + probScen2*z2 + probScen3*z3 >= probMin;

