/*********************************************
 * AMPLModel
 * Author: LuigiDeGiovanni
 *********************************************/

param parProd1 := 1.4;  #scenario 1, prob. 1/4
param parProd2 := 0.9;  #scenario 2, prob. 1/2
param parProd3 := 0.8;  #scenario 3, prob. 1/4

#decisioni indipendenti dallo scenario
var x_b >=0 integer;		# numero macchine dedicate a bulloni
var x_c >=0 integer;		# numero macchine dedicate a chiodi
var x_d >=0 integer;		# numero macchine dedicate a dadi

#decisioni dipendenti dallo scenario
#scenario 1
var y_b1 >=0;		# kg di bulloni acquistati
var z_b1 >=0;		# kg di bulloni venduti
var y_c1 >=0;		# kg di chiodi acquistati
var z_c1 >=0;		# kg di chiodi venduti
var y_d1 >=0;		# kg di dadi acquistati
var z_d1 >=0;		# kg di dadi venduti
#scenario 2
var y_b2 >=0;		# kg di bulloni acquistati
var z_b2 >=0;		# kg di bulloni venduti
var y_c2 >=0;		# kg di chiodi acquistati
var z_c2 >=0;		# kg di chiodi venduti
var y_d2 >=0;		# kg di dadi acquistati
var z_d2 >=0;		# kg di dadi venduti
#scenario 3
var y_b3 >=0;		# kg di bulloni acquistati
var z_b3 >=0;		# kg di bulloni venduti
var y_c3 >=0;		# kg di chiodi acquistati
var z_c3 >=0;		# kg di chiodi venduti
var y_d3 >=0;		# kg di dadi acquistati
var z_d3 >=0;		# kg di dadi venduti

maximize profittomedio:
#ricavo-costo atteso (post-produzione)
    1/4 * (    140*z_b1 +  30*z_c1 + 170*z_d1
             - 160*y_b1 -  40*y_c1 - 200*y_d1 )
  + 1/2 * (    140*z_b2 +  30*z_c2 + 170*z_d2
             - 160*y_b2 -  40*y_c2 - 200*y_d2 )
  + 1/4 * (    140*z_b3 +  30*z_c3 + 170*z_d3
             - 160*y_b3 -  40*y_c3 - 200*y_d3 )
# costi (pre-produzione)
  - 230*x_b - 260*x_c - 150*x_d ;
  			 
subject to num_macchine:	x_b + x_c + x_d <= 500;

subject to qta_bulloni_s1: parProd1* 3  *x_b + y_b1 >= 240 + z_b1;
subject to qta_chiodi_s1:  parProd1*20  *x_c + y_c1 >= 100 + z_c1;
subject to qta_dadi_s1:    parProd1* 2.5*x_d + y_d1 >= 200 + z_d1;
subject to qta_acquisti_s1:       y_b1 + y_c1 + y_d1 <= 1000;
subject to qta_vendite_s1:        z_b1 + z_c1 + z_d1 <= 1000;
  			 
subject to qta_bulloni_s2: parProd2* 3  *x_b + y_b2 >= 240 + z_b2;
subject to qta_chiodi_s2:  parProd2*20  *x_c + y_c2 >= 100 + z_c2;
subject to qta_dadi_s2:    parProd2* 2.5*x_d + y_d2 >= 200 + z_d2;
subject to qta_acquisti_s2:       y_b2 + y_c2 + y_d2 <= 1000;
subject to qta_vendite_s2:        z_b2 + z_c2 + z_d2 <= 1000;

subject to qta_bulloni_s3: parProd3* 3  *x_b + y_b3 >= 240 + z_b3;
subject to qta_chiodi_s3:  parProd3*20  *x_c + y_c3 >= 100 + z_c3;
subject to qta_dadi_s3:    parProd3* 2.5*x_d + y_d3 >= 200 + z_d3;
subject to qta_acquisti_s3:       y_b3 + y_c3 + y_d3 <= 1000;
subject to qta_vendite_s:        z_b3 + z_c3 + z_d3 <= 1000;

