/*********************************************
 * AMPL Model
 * Author: LuigiDeGiovanni
  *********************************************/

param	parProd := 1.0;	# moltiplicatore della produttivit rispetto alla stima

# variabili decisionali
var	x_b >=0 integer;	# numero macchine dedicate a bulloni (variabile intera non negativa)
var	x_c >=0 integer;	# numero macchine dedicate a chiodi
var	x_d >=0 integer;	# numero macchine dedicate a dadi 
var	y_b >=0;			# kg di bulloni acquistati
var	y_c >=0;			# kg di chiodi acquistati
var	y_d >=0;			# kg di dadi acquistati
var	z_b >=0;			# kg di bulloni extra venduti
var	z_c >=0;			# kg di chiodi extra venduti
var	z_d >=0;			# kg di dadi extra venduti

# funzione obiettivo
maximize profitto:
    140*z_b +  30*z_c + 170*z_d
  - 230*x_b - 260*x_c - 150*x_d
  - 160*y_b -  40*y_c - 200*y_d;

# vincoli
subject to num_macchine:        x_b + x_c + x_d <= 500;
subject to qta_bulloni : parProd* 3  *x_b + y_b >= 240 + z_b;
subject to qta_chiodi  : parProd*20  *x_c + y_c >= 100 + z_c;
subject to qta_dadi    : parProd* 2.5*x_d + y_d >= 200 + z_d;
subject to qta_acquisti:        y_b + y_c + y_d <= 1000;
subject to qta_vendite :        z_b + z_c + z_d <= 1000;
