/**
 * @file TSPSolver.cpp
 * @brief TSP solver (neighborhood search)
 *
 */

#include "TSPSolver.h"
#include <iostream>

bool TSPSolver::solve ( const TSP& tsp , const TSPSolution& initSol , TSPSolution& bestSol )
{
  try
  {
    bool stop = false;
    int  iter = 0;

    TSPSolution currSol(initSol);

    while ( ! stop ) {
      if ( tsp.n < 20 ) currSol.print(); std::cout << '\n';
		
    	/// TODO: replace the following by the local search iteration 
      //  that updates currSol if an improving neighbor exists and 
      //  stops otherwise

      TSPMove move;
      TSPSolution neighSol(tsp);
      TSPSolution neighBest(currSol);
      for ( int i_subs_init = 1 ; i_subs_init < currSol.sequence.size()-2; ++i_subs_init ) {
        for ( int i_subs_end = i_subs_init+1 ; i_subs_end < currSol.sequence.size()-1; ++i_subs_end ) {
          move.substring_begin = i_subs_init;
          move.substring_end   = i_subs_end;
          neighSol = apply2optMove(currSol,move);
          //if ( i_subs_init == 1 && i_subs_end == i_subs_init+1 ) neighSol.print();
          double neighCost = this->evaluate(neighSol,tsp);
          double bestCost = this->evaluate(neighBest,tsp);
          double neighImprov = neighCost - bestCost;
          if ( neighImprov < -1e-6 ) {
            neighBest = neighSol;
          }
        }
      }
      double currCost = this->evaluate(currSol,tsp);
      double bestCost = this->evaluate(neighBest,tsp);
      if ( bestCost - currCost < -1e-6 ) {
        currSol = neighBest;
      } else {
        stop = true;
      }
    }
    bestSol = currSol;
  }
  catch(std::exception& e)
  {
    std::cout << ">>>EXCEPTION: " << e.what() << std::endl;
    return false;
  }
  return true;
}

//TODO: "internal methods", if any
TSPSolution TSPSolver::apply2optMove( const TSPSolution& tspSol , const TSPMove& move ) {
  TSPSolution tmpSol(tspSol);
  for ( int i = move.substring_begin ; i <= move.substring_end ; ++ i ) {
    tmpSol.sequence[i] = tspSol.sequence[move.substring_end-(i-move.substring_begin)];
  }
  return tmpSol;
}
