from docplex.mp.model import Model

###DATA (can be read from a file)
#data for farmer 4.0
modelname = "farmer 4.0"
Products_I  = ["tomato","potato"]
Resources_J = ["land","tomato seeds","potato tubers","fertilizer"]
D = {"land": 11, "tomato seeds": 70, "potato tubers": 18, "fertilizer": 145}
P = {"tomato": 6000, "potato": 7000}
Q = {("tomato","land"): 1, ("tomato","tomato seeds"): 7, ("tomato","potato tubers"): 0, ("tomato","fertilizer"): 10,
     ("potato","land"): 1, ("potato","tomato seeds"): 0, ("potato","potato tubers"): 3, ("potato","fertilizer"): 20 }
decision_domain = "continuous"

#data for young money makers
#modelname = "young money makers"
#Products_I  = ["Tshirts","bags"]
#Resources_J = ["roughTshirts","roughBags",...]
#D = ...
#P = ...
#Q = ...
#decision_domain = "discrete"

####DATA-INDEPENDENT MODEL
m = Model(name="production mix: "+modelname)
if decision_domain == "continuous":
    x = {i: m.continuous_var(name='x({0})'.format(i)) for i in Products_I}
elif decision_domain == "discrete":
    x = {i: m.integer_var(name='x({0})'.format(i)) for i in Products_I}
elif decision_domain == "binary":
    x = {i: m.binary_var(name='x({0})'.format(i)) for i in Products_I}
else:
    print("ERROR: unknown variable domain")
    exit()

m.maximize(m.sum(P[i]*x[i] for i in Products_I))
for j in Resources_J:
    m.add_constraint(m.sum(Q[(i,j)]*x[i] for i in Products_I) <= D[j])

m.print_information()

if m.solve(log_output = True):
    m.print_solution()
else:
    print(m.get_solve_status())
