from docplex.mp.model import Model
m = Model(name="young money makers")
xT = m.integer_var(name="num of T-shirts")
xB = m.integer_var(name="num of bags")
revenue = 24 * xT + 16 * xB
m.add_constraint(   xT         <=  10)
m.add_constraint(           xB <=  15)
m.add_constraint( 6*xT +  3*xB <=  32)
m.add_constraint(   xT +  2*xB <=  24)
m.add_constraint( 2*xT +  2*xB <=  40)
m.add_constraint(         2*xB <=  15)
m.maximize(revenue)
m.print_information() #display information on the model 
m.solve(log_output = True)
if m.solution:
    m.print_solution()    #display information on the solution
else:
    print("No solution available. ",m.get_solve_status())