from docplex.mp.model import Model

m = Model(name = "diet model")
x_v = m.continuous_var(lb = 0, ub = None, name="vegetables kg")
x_m = m.continuous_var(lb = 0, ub = None, name="meat kg") 
x_f = m.continuous_var(lb = 0, ub = None, name="fruit kg")
ob_fun = 4*x_v + 10*x_m + 7*x_f # total cost
m.minimize(ob_fun)
m.add_constraint(5*x_v + 15*x_m + 4*x_f >= 20) # proteins supply
m.add_constraint(6*x_v + 10*x_m + 5*x_f >= 30) # iron supply
m.add_constraint(5*x_v + 3*x_m + 12*x_f >= 10) # calcium supply

m.print_information() #display information on the model 

m.export_as_lp(basename='diet', path = 'specify the path in which to save the model', hide_user_names=False) # export the model in the given path in LP format

m.solve()

if m.solution:
  m.print_solution()    #display information on the solution
  m.solution.export('diet_solution.json') # exports solution in a json file
  with open('diet_solution.txt','w') as solfile: # exports the solution in a text file
    solfile.write(m.solution.to_string())
else:
  print(m.get_solve_status())