from docplex.mp.model import Model
import json
import ast
import sys

# TRANSPORTATION MODEL

###DATA (read from a file, Load the JSON file)
with open(sys.argv[1] if len(sys.argv)>1 else 'transport_basic.json', 'r') as file:
    data = json.load(file)

modelname = data["modelname"]
#read sets
I = data["I"] # given as ordered list of origins
J = data["J"] # given as ordered list of destinations
#read parameters
o_list = data["o_list"] # ORDERED list of the origins capacity
d_list = data["d_list"] # ORDERED list of the destinations requests
c_matrix = data["c_matrix"] # o/d cost matrix based on the order of orgines and destinations
decision_domain =  data["decision_domain"]

####DATA-INDEPENDENT MODEL CREATION
# data preprocessing (transform ordered list into dictionaries, for ease of reference)
O = {}
for i in range(len(I)):
    O[I[i]] = o_list[i] # capacity of each origin 

D = {J[j]: d_list[j] for j in range(len(J))} # request of each destination

C = { (I[i],J[j]): c_matrix[i][j] for i in range(len(I)) for j in range(len(J))} # transport cost of a unit from origin i to destination j

# model definition
m = Model(name = "transportation")

if decision_domain == "discrete":
    x = m.integer_var_matrix(keys1 = I,keys2 = J,lb = 0, ub = None, name = 'x')
else:
    x = m.continuous_var_matrix(keys1 = I,keys2 = J,lb = 0, ub = None, name = 'x')


m.minimize(m.sum(C[(i,j)]*x[(i,j)] for i in I for j in J))

for j in J:
    m.add_constraint(m.sum(x[(i,j)] for i in I)>= D[j])

m.add_constraints(m.sum(x[(i,j)] for j in J)<= O[i] for i in I)

m.print_information() #display information on the model 
m.export_as_lp(basename='transport', path = '.', hide_user_names=False) # export the model in the given path in LP format

if m.solve(log_output=True):
    m.print_solution()    #display information on the solution
    m.solution.export('transport_solution.json') # exports solution in a json file
else:
    print(m.get_solve_status())



