from docplex.mp.model import Model
import json
import ast
import sys

###DATA (read from a file, Load the JSON file)
with open(sys.argv[1] if len(sys.argv)>1 else 'prodmix.json', 'r') as file:
    data = json.load(file)

modelname = data["modelname"]
Products_I  = data["Products_I"]
Resources_J = data["Resources_J"]
D = data["D"]
P =  data["P"]
Q = {ast.literal_eval(k): v for k, v in data["Q"].items()}
decision_domain =  data["decision_domain"]

####DATA-INDEPENDENT MODEL
m = Model(name="production mix: "+modelname)
if decision_domain == "continuous":
    x = m.continuous_var_dict(keys = Products_I,lb = 0, ub = None, name = 'x')
elif decision_domain == "discrete":
    x = m.integer_var_dict(keys = Products_I,lb = 0, ub = None, name = 'x')
elif decision_domain == "binary":
    x = m.binary_var_dict(keys = Products_I,lb = 0, ub = None, name = 'x')
else:
    print("ERROR: unknown variable domain")
    exit()

m.maximize(sum(P[i]*x[i] for i in Products_I))

m.add_constraints(sum(Q[(i,j)]*x[i] for i in Products_I) <= D[j] for j in Resources_J)

m.print_information()

if m.solve(log_output = True):
    m.print_solution()
else:
    print(m.get_solve_status())
