from docplex.mp.model import Model

# MINIMUM COST COVERING 

# model sets
I = ['V','M','F'] # set of the resources: vegetables, meat, fruit
J = ['p','i','c'] # set of requests: proteins, iron, calcium

# model parameteres 
C = {'V': 4,'M': 10,'F':7} # cost of the resources (euros/kg)
R = {'p': 20,'i': 30,'c':10} # requested amount (mg)
A = {('V','p'): 5,('V','i'): 6,('V','c'): 5,('M','p'): 15,('M','i'): 10,('M','c'): 3,('F','p'): 4,('F','i'): 5,('F','c'): 12} # amount of request j satisfied by one unit of resource i
decision_domain = "continuous"

# data-independent model
m = Model(name = "minimum cost covering")

if decision_domain == "continuous":
    x = m.continuous_var_dict(keys = I,lb = 0, ub = None, name = 'x')
elif decision_domain == "discrete":
    x = m.integer_var_dict(keys = I,lb = 0, ub = None, name = 'x')
elif decision_domain == "binary":
    x = m.binary_var_dict(keys = I,lb = 0, ub = None, name = 'x')
else:
    print("ERROR: unknown variable domain")
    exit()

m.minimize(m.sum(C[i]*x[i] for i in I))

m.add_constraints(m.sum(A[(i,j)]*x[i] for i in I)>= R[j] for j in J)

m.print_information() #display information on the model 

if m.solve():
    m.print_solution()    #display information on the solution
else:
    print(m.get_solve_status())