from docplex.mp.model import Model

m = Model(name="perfumes model")

x_one = m.continuous_var(lb = 0, ub = None, name="perfume one Dl")
x_two = m.continuous_var(lb = 0, ub = None, name="perfume two Dl")

ob_fun = 130*x_one + 100*x_two #total profit
m.maximize(ob_fun)

m.add_constraint(1.5*x_one + x_two <= 27) # availability of rose
m.add_constraint(x_one + x_two <= 21) # availability of lily
m.add_constraint(0.3*x_one + 0.5*x_two <= 9) # availability of violet

m.print_information() #display information on the model 
m.export_as_lp(basename='perfumes', path = 'specify the path in which to save the model', hide_user_names=False) # export the model in the given path in LP format

sol = m.solve()

if sol:
  m.print_solution()    #display information on the solution
  sol.export('perfumes_solution.json') # exports solution in a json file
  with open('perfumes_solution.txt','w') as solfile: # exports the solution in a text file
    solfile.write(m.solution.to_string())
else:
  print(m.get_solve_status())