from docplex.mp.model import Model

m = Model(name="farmer Tom")

xT = m.continuous_var(name="hectars of tomatoes", lb = 0, ub = None) #defaulta values for lb=0 and ub=None to say xT>=0
xP = m.continuous_var(name="hectars of potatoes", lb = 0, ub = None)

revenue = 6000 * xT + 7000 * xP

m.add_constraint(   xT +    xP <=  11,ctname="land availability") #ctname is optional
m.add_constraint( 7*xT         <=  70,ctname="tomato-seeds availability")
m.add_constraint(         3*xP <=  18,ctname="poteto tubers availability")
m.add_constraint(10*xT + 20*xP <= 145,ctname="fertilizer availability")

m.maximize(revenue)

m.print_information()     #display information on the model 
m.export_as_lp(path='.')  # export the model in the given path in LP format

m.solve()

if m.solution != None:  #solution available
  m.print_solution()    #display information on the solution
  if m.solution[xT] > 5.5:
    print("A lot of tomatoes!")
  else:
    print("Not so much tomatoes")
  
  m.solution.export('farm_solution.json')         #export solution in a json file
  with open('farm_solution.txt','w') as solfile:  #export solution in a plain text file
    solfile.write(m.solution.to_string())
  
else:   #no solution available (e.g., infeasible model)
  print(m.get_solve_status())