from docplex.mp.model import Model

I = [1,2,3,4,5,6] # set of potential locations


m = Model(name = "emergency_location")
x = m.binary_var_dict(keys = I, name = 'x') #name of each variable will be completed by adding '_element_of_I' to the given 'x'

m.minimize(m.sum(x[i]for i in I))

m.add_constraint(x[1]+x[2]>=1,ctname='cover zone 1')
m.add_constraint(x[1]+x[2]+x[6]>=1,ctname='cover zone 2')
m.add_constraint(x[3]+x[4]>=1,ctname='cover zone 3')
m.add_constraint(x[3]+x[4]+x[5]>=1,ctname='cover zone 4')
m.add_constraint(x[4]+x[5]+x[6]>=1,ctname='cover zone 5')
m.add_constraint(x[2]+x[5]+x[6]>=1,ctname='cover zone 6')

m.print_information() #display information on the model 
if m.solve():
    m.print_solution()    #display information on the solution
else:
    print(m.get_solve_status())