/**********************************************************************************************************************
 * \file Ifx_Cfg_SswBmhd.c
 * \brief This file contains the Bmhd for Aurix TC3XX.
 * \copyright Copyright (C) Infineon Technologies AG 2019
 * 
 * Use of this file is subject to the terms of use agreed between (i) you or the company in which ordinary course of 
 * business you are acting and (ii) Infineon Technologies AG or its licensees. If and as long as no such terms of use
 * are agreed, use of this file is subject to following:
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization obtaining a copy of the software and 
 * accompanying documentation covered by this license (the "Software") to use, reproduce, display, distribute, execute,
 * and transmit the Software, and to prepare derivative works of the Software, and to permit third-parties to whom the
 * Software is furnished to do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including the above license grant, this restriction
 * and the following disclaimer, must be included in all copies of the Software, in whole or in part, and all 
 * derivative works of the Software, unless such copies or derivative works are solely in the form of 
 * machine-executable object code generated by a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE 
 * COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN 
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 *********************************************************************************************************************/
 
/*********************************************************************************************************************/
/*-----------------------------------------------------Includes------------------------------------------------------*/
/*********************************************************************************************************************/
#include "Ifx_Ssw.h"

/*********************************************************************************************************************/
/*--------------------------------------------------BMHD constants---------------------------------------------------*/
/*********************************************************************************************************************/
#if defined(__HIGHTEC__)
#pragma section
#pragma section ".bmhd_0_orig" a
#endif
#if defined(__TASKING__)
#pragma section farrom "bmhd_0_orig"
#endif
#if defined(__DCC__)
#pragma section CONST ".bmhd_0_orig" far-absolute R
#endif
#if defined(__ghs__)
#pragma ghs section rodata= ".bmhd_0_orig"
#endif
const Ifx_Ssw_Bmhd bmhd_0_orig =
{
    0x007E,         /* 0x000: .bmi: Boot Mode Index (BMI)                                               */
    0xB359,         /* 0x002: .bmhdid: Boot Mode Header ID (CODE) = B359H                               */
    0xA0000000,     /* 0x004: .stad: User Code start address                                            */
    0x809FE5E2,     /* 0x008: .crc: Check Result for the BMI Header (offset 000H - 007H)                */
    0x7F601A1D,     /* 0x00C: .crcInv: Inverted Check Result for the BMI Header (offset 000H - 007H)    */
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x010: Reserved (0x010 - 0x01F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x020: Reserved (0x020 - 0x02F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x030: Reserved (0x030 - 0x03F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x040: Reserved (0x040 - 0x04F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x050: Reserved (0x050 - 0x05F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x060: Reserved (0x060 - 0x06F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x070: Reserved (0x070 - 0x07F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x080: Reserved (0x080 - 0x08F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x090: Reserved (0x090 - 0x09F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0A0: Reserved (0x0A0 - 0x0AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0B0: Reserved (0x0B0 - 0x0BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0C0: Reserved (0x0C0 - 0x0CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0D0: Reserved (0x0D0 - 0x0DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0E0: Reserved (0x0E0 - 0x0EF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x0F0: Reserved (0x0F0 - 0x0FF)       */
    },
    {
        0x00000000, /* 0x100: .pw0: Password protection word 0 (lsw)                                    */
        0x00000000, /* 0x104: .pw1: Password protection word 1                                          */
        0x00000000, /* 0x108: .pw2: Password protection word 2                                          */
        0x00000000, /* 0x10C: .pw3: Password protection word 3                                          */
        0x00000000, /* 0x110: .pw4: Password protection word 4                                          */
        0x00000000, /* 0x114: .pw5: Password protection word 5                                          */
        0x00000000, /* 0x118: .pw6: Password protection word 6                                          */
        0x00000000, /* 0x11C: .pw7: Password protection word 7 (msw)                                    */
    },
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x120: Reserved (0x120 - 0x12F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x130: Reserved (0x130 - 0x13F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x140: Reserved (0x140 - 0x14F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x150: Reserved (0x150 - 0x15F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x160: Reserved (0x160 - 0x16F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x170: Reserved (0x170 - 0x17F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x180: Reserved (0x180 - 0x18F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x190: Reserved (0x190 - 0x19F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1A0: Reserved (0x1A0 - 0x1AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1B0: Reserved (0x1B0 - 0x1BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1C0: Reserved (0x1C0 - 0x1CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1D0: Reserved (0x1D0 - 0x1DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x1E0: Reserved (0x1E0 - 0x1EF)       */
    },
    0x43211234      /* 0x1F0: .confirmation: 32-bit CODE, (always same)                                 */
};

#if defined(__HIGHTEC__)
#pragma section
#pragma section ".bmhd_0_copy" a
#endif
#if defined(__TASKING__)
#pragma section farrom "bmhd_0_copy"
#endif
#if defined(__DCC__)
#pragma section CONST ".bmhd_0_copy" far-absolute R
#endif
#if defined(__ghs__)
#pragma ghs section rodata= ".bmhd_0_copy"
#endif
const Ifx_Ssw_Bmhd bmhd_0_copy =
{
    0x007E,         /* 0x000: .bmi: Boot Mode Index (BMI)                                               */
    0xB359,         /* 0x002: .bmhdid: Boot Mode Header ID (CODE) = B359H                               */
    0xA0000000,     /* 0x004: .stad: User Code start address                                            */
    0x809FE5E2,     /* 0x008: .crc: Check Result for the BMI Header (offset 000H - 007H)                */
    0x7F601A1D,     /* 0x00C: .crcInv: Inverted Check Result for the BMI Header (offset 000H - 007H)    */
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x010: Reserved (0x010 - 0x01F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x020: Reserved (0x020 - 0x02F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x030: Reserved (0x030 - 0x03F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x040: Reserved (0x040 - 0x04F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x050: Reserved (0x050 - 0x05F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x060: Reserved (0x060 - 0x06F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x070: Reserved (0x070 - 0x07F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x080: Reserved (0x080 - 0x08F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x090: Reserved (0x090 - 0x09F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0A0: Reserved (0x0A0 - 0x0AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0B0: Reserved (0x0B0 - 0x0BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0C0: Reserved (0x0C0 - 0x0CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0D0: Reserved (0x0D0 - 0x0DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0E0: Reserved (0x0E0 - 0x0EF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x0F0: Reserved (0x0F0 - 0x0FF)       */
    },
    {
        0x00000000, /* 0x100: .pw0: Password protection word 0 (lsw)                                    */
        0x00000000, /* 0x104: .pw1: Password protection word 1                                          */
        0x00000000, /* 0x108: .pw2: Password protection word 2                                          */
        0x00000000, /* 0x10C: .pw3: Password protection word 3                                          */
        0x00000000, /* 0x110: .pw4: Password protection word 4                                          */
        0x00000000, /* 0x114: .pw5: Password protection word 5                                          */
        0x00000000, /* 0x118: .pw6: Password protection word 6                                          */
        0x00000000, /* 0x11C: .pw7: Password protection word 7 (msw)                                    */
    },
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x120: Reserved (0x120 - 0x12F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x130: Reserved (0x120 - 0x13F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x140: Reserved (0x120 - 0x14F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x150: Reserved (0x120 - 0x15F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x160: Reserved (0x120 - 0x16F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x170: Reserved (0x120 - 0x17F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x180: Reserved (0x120 - 0x18F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x190: Reserved (0x120 - 0x19F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1A0: Reserved (0x120 - 0x1AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1B0: Reserved (0x120 - 0x1BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1C0: Reserved (0x120 - 0x1CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1D0: Reserved (0x120 - 0x1DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1E0: Reserved (0x120 - 0x1EF)       */
    },
    0x43211234      /* 0x1F0: .confirmation: 32-bit CODE, (always same)                                 */
};

#if defined(__HIGHTEC__)
#pragma section
#pragma section ".bmhd_1_orig" a
#endif
#if defined(__TASKING__)
#pragma section farrom "bmhd_1_orig"
#endif
#if defined(__DCC__)
#pragma section CONST ".bmhd_1_orig" far-absolute R
#endif
#if defined(__ghs__)
#pragma ghs section rodata= ".bmhd_1_orig"
#endif
const Ifx_Ssw_Bmhd bmhd_1_orig =
{
    0x007E,         /* 0x000: .bmi: Boot Mode Index (BMI)                                               */
    0xB359,         /* 0x002: .bmhdid: Boot Mode Header ID (CODE) = B359H                               */
    0xA0000000,     /* 0x004: .stad: User Code start address                                            */
    0x809FE5E2,     /* 0x008: .crc: Check Result for the BMI Header (offset 000H - 007H)                */
    0x7F601A1D,     /* 0x00C: .crcInv: Inverted Check Result for the BMI Header (offset 000H - 007H)    */
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x010: Reserved (0x010 - 0x01F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x020: Reserved (0x020 - 0x02F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x030: Reserved (0x030 - 0x03F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x040: Reserved (0x040 - 0x04F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x050: Reserved (0x050 - 0x05F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x060: Reserved (0x060 - 0x06F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x070: Reserved (0x070 - 0x07F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x080: Reserved (0x080 - 0x08F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x090: Reserved (0x090 - 0x09F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0A0: Reserved (0x0A0 - 0x0AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0B0: Reserved (0x0B0 - 0x0BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0C0: Reserved (0x0C0 - 0x0CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0D0: Reserved (0x0D0 - 0x0DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0E0: Reserved (0x0E0 - 0x0EF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x0F0: Reserved (0x0F0 - 0x0FF)       */
    },
    {
        0x00000000, /* 0x100: .pw0: Password protection word 0 (lsw)                                    */
        0x00000000, /* 0x104: .pw1: Password protection word 1                                          */
        0x00000000, /* 0x108: .pw2: Password protection word 2                                          */
        0x00000000, /* 0x10C: .pw3: Password protection word 3                                          */
        0x00000000, /* 0x110: .pw4: Password protection word 4                                          */
        0x00000000, /* 0x114: .pw5: Password protection word 5                                          */
        0x00000000, /* 0x118: .pw6: Password protection word 6                                          */
        0x00000000, /* 0x11C: .pw7: Password protection word 7 (msw)                                    */
    },
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x120: Reserved (0x120 - 0x12F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x130: Reserved (0x130 - 0x13F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x140: Reserved (0x140 - 0x14F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x150: Reserved (0x150 - 0x15F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x160: Reserved (0x160 - 0x16F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x170: Reserved (0x170 - 0x17F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x180: Reserved (0x180 - 0x18F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x190: Reserved (0x190 - 0x19F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1A0: Reserved (0x1A0 - 0x1AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1B0: Reserved (0x1B0 - 0x1BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1C0: Reserved (0x1C0 - 0x1CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1D0: Reserved (0x1D0 - 0x1DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x1E0: Reserved (0x1E0 - 0x1EF)       */
    },
    0x43211234      /* 0x1F0: .confirmation: 32-bit CODE, (always same)                                 */
};

#if defined(__HIGHTEC__)
#pragma section
#pragma section ".bmhd_1_copy" a
#endif
#if defined(__TASKING__)
#pragma section farrom "bmhd_1_copy"
#endif
#if defined(__DCC__)
#pragma section CONST ".bmhd_1_copy" far-absolute R
#endif
#if defined(__ghs__)
#pragma ghs section rodata= ".bmhd_1_copy"
#endif
const Ifx_Ssw_Bmhd bmhd_1_copy =
{
    0x007E,         /* 0x000: .bmi: Boot Mode Index (BMI)                                               */
    0xB359,         /* 0x002: .bmhdid: Boot Mode Header ID (CODE) = B359H                               */
    0xA0000000,     /* 0x004: .stad: User Code start address                                            */
    0x809FE5E2,     /* 0x008: .crc: Check Result for the BMI Header (offset 000H - 007H)                */
    0x7F601A1D,     /* 0x00C: .crcInv: Inverted Check Result for the BMI Header (offset 000H - 007H)    */
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x010: Reserved (0x010 - 0x01F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x020: Reserved (0x020 - 0x02F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x030: Reserved (0x030 - 0x03F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x040: Reserved (0x040 - 0x04F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x050: Reserved (0x050 - 0x05F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x060: Reserved (0x060 - 0x06F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x070: Reserved (0x070 - 0x07F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x080: Reserved (0x080 - 0x08F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x090: Reserved (0x090 - 0x09F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0A0: Reserved (0x0A0 - 0x0AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0B0: Reserved (0x0B0 - 0x0BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0C0: Reserved (0x0C0 - 0x0CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0D0: Reserved (0x0D0 - 0x0DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0E0: Reserved (0x0E0 - 0x0EF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x0F0: Reserved (0x0F0 - 0x0FF)       */
    },
    {
        0x00000000, /* 0x100: .pw0: Password protection word 0 (lsw)                                    */
        0x00000000, /* 0x104: .pw1: Password protection word 1                                          */
        0x00000000, /* 0x108: .pw2: Password protection word 2                                          */
        0x00000000, /* 0x10C: .pw3: Password protection word 3                                          */
        0x00000000, /* 0x110: .pw4: Password protection word 4                                          */
        0x00000000, /* 0x114: .pw5: Password protection word 5                                          */
        0x00000000, /* 0x118: .pw6: Password protection word 6                                          */
        0x00000000, /* 0x11C: .pw7: Password protection word 7 (msw)                                    */
    },
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x120: Reserved (0x120 - 0x12F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x130: Reserved (0x120 - 0x13F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x140: Reserved (0x120 - 0x14F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x150: Reserved (0x120 - 0x15F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x160: Reserved (0x120 - 0x16F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x170: Reserved (0x120 - 0x17F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x180: Reserved (0x120 - 0x18F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x190: Reserved (0x120 - 0x19F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1A0: Reserved (0x120 - 0x1AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1B0: Reserved (0x120 - 0x1BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1C0: Reserved (0x120 - 0x1CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1D0: Reserved (0x120 - 0x1DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1E0: Reserved (0x120 - 0x1EF)       */
    },
    0x43211234      /* 0x1F0: .confirmation: 32-bit CODE, (always same)                                 */
};

#if defined(__HIGHTEC__)
#pragma section
#pragma section ".bmhd_2_orig" a
#endif
#if defined(__TASKING__)
#pragma section farrom "bmhd_2_orig"
#endif
#if defined(__DCC__)
#pragma section CONST ".bmhd_2_orig" far-absolute R
#endif
#if defined(__ghs__)
#pragma ghs section rodata= ".bmhd_2_orig"
#endif
const Ifx_Ssw_Bmhd bmhd_2_orig =
{
    0x007E,         /* 0x000: .bmi: Boot Mode Index (BMI)                                               */
    0xB359,         /* 0x002: .bmhdid: Boot Mode Header ID (CODE) = B359H                               */
    0xA0000000,     /* 0x004: .stad: User Code start address                                            */
    0x809FE5E2,     /* 0x008: .crc: Check Result for the BMI Header (offset 000H - 007H)                */
    0x7F601A1D,     /* 0x00C: .crcInv: Inverted Check Result for the BMI Header (offset 000H - 007H)    */
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x010: Reserved (0x010 - 0x01F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x020: Reserved (0x020 - 0x02F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x030: Reserved (0x030 - 0x03F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x040: Reserved (0x040 - 0x04F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x050: Reserved (0x050 - 0x05F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x060: Reserved (0x060 - 0x06F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x070: Reserved (0x070 - 0x07F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x080: Reserved (0x080 - 0x08F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x090: Reserved (0x090 - 0x09F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0A0: Reserved (0x0A0 - 0x0AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0B0: Reserved (0x0B0 - 0x0BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0C0: Reserved (0x0C0 - 0x0CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0D0: Reserved (0x0D0 - 0x0DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0E0: Reserved (0x0E0 - 0x0EF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x0F0: Reserved (0x0F0 - 0x0FF)       */
    },
    {
        0x00000000, /* 0x100: .pw0: Password protection word 0 (lsw)                                    */
        0x00000000, /* 0x104: .pw1: Password protection word 1                                          */
        0x00000000, /* 0x108: .pw2: Password protection word 2                                          */
        0x00000000, /* 0x10C: .pw3: Password protection word 3                                          */
        0x00000000, /* 0x110: .pw4: Password protection word 4                                          */
        0x00000000, /* 0x114: .pw5: Password protection word 5                                          */
        0x00000000, /* 0x118: .pw6: Password protection word 6                                          */
        0x00000000, /* 0x11C: .pw7: Password protection word 7 (msw)                                    */
    },
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x120: Reserved (0x120 - 0x12F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x130: Reserved (0x130 - 0x13F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x140: Reserved (0x140 - 0x14F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x150: Reserved (0x150 - 0x15F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x160: Reserved (0x160 - 0x16F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x170: Reserved (0x170 - 0x17F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x180: Reserved (0x180 - 0x18F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x190: Reserved (0x190 - 0x19F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1A0: Reserved (0x1A0 - 0x1AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1B0: Reserved (0x1B0 - 0x1BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1C0: Reserved (0x1C0 - 0x1CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1D0: Reserved (0x1D0 - 0x1DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x1E0: Reserved (0x1E0 - 0x1EF)       */
    },
    0x43211234      /* 0x1F0: .confirmation: 32-bit CODE, (always same)                                 */
};

#if defined(__HIGHTEC__)
#pragma section
#pragma section ".bmhd_2_copy" a
#endif
#if defined(__TASKING__)
#pragma section farrom "bmhd_2_copy"
#endif
#if defined(__DCC__)
#pragma section CONST ".bmhd_2_copy" far-absolute R
#endif
#if defined(__ghs__)
#pragma ghs section rodata= ".bmhd_2_copy"
#endif
const Ifx_Ssw_Bmhd bmhd_2_copy =
{
    0x007E,         /* 0x000: .bmi: Boot Mode Index (BMI)                                               */
    0xB359,         /* 0x002: .bmhdid: Boot Mode Header ID (CODE) = B359H                               */
    0xA0000000,     /* 0x004: .stad: User Code start address                                            */
    0x809FE5E2,     /* 0x008: .crc: Check Result for the BMI Header (offset 000H - 007H)                */
    0x7F601A1D,     /* 0x00C: .crcInv: Inverted Check Result for the BMI Header (offset 000H - 007H)    */
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x010: Reserved (0x010 - 0x01F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x020: Reserved (0x020 - 0x02F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x030: Reserved (0x030 - 0x03F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x040: Reserved (0x040 - 0x04F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x050: Reserved (0x050 - 0x05F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x060: Reserved (0x060 - 0x06F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x070: Reserved (0x070 - 0x07F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x080: Reserved (0x080 - 0x08F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x090: Reserved (0x090 - 0x09F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0A0: Reserved (0x0A0 - 0x0AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0B0: Reserved (0x0B0 - 0x0BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0C0: Reserved (0x0C0 - 0x0CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0D0: Reserved (0x0D0 - 0x0DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0E0: Reserved (0x0E0 - 0x0EF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x0F0: Reserved (0x0F0 - 0x0FF)       */
    },
    {
        0x00000000, /* 0x100: .pw0: Password protection word 0 (lsw)                                    */
        0x00000000, /* 0x104: .pw1: Password protection word 1                                          */
        0x00000000, /* 0x108: .pw2: Password protection word 2                                          */
        0x00000000, /* 0x10C: .pw3: Password protection word 3                                          */
        0x00000000, /* 0x110: .pw4: Password protection word 4                                          */
        0x00000000, /* 0x114: .pw5: Password protection word 5                                          */
        0x00000000, /* 0x118: .pw6: Password protection word 6                                          */
        0x00000000, /* 0x11C: .pw7: Password protection word 7 (msw)                                    */
    },
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x120: Reserved (0x120 - 0x12F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x130: Reserved (0x120 - 0x13F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x140: Reserved (0x120 - 0x14F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x150: Reserved (0x120 - 0x15F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x160: Reserved (0x120 - 0x16F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x170: Reserved (0x120 - 0x17F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x180: Reserved (0x120 - 0x18F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x190: Reserved (0x120 - 0x19F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1A0: Reserved (0x120 - 0x1AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1B0: Reserved (0x120 - 0x1BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1C0: Reserved (0x120 - 0x1CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1D0: Reserved (0x120 - 0x1DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1E0: Reserved (0x120 - 0x1EF)       */
    },
    0x43211234      /* 0x1F0: .confirmation: 32-bit CODE, (always same)                                 */
};

#if defined(__HIGHTEC__)
#pragma section
#pragma section ".bmhd_3_orig" a
#endif
#if defined(__TASKING__)
#pragma section farrom "bmhd_3_orig"
#endif
#if defined(__DCC__)
#pragma section CONST ".bmhd_3_orig" far-absolute R
#endif
#if defined(__ghs__)
#pragma ghs section rodata= ".bmhd_3_orig"
#endif
const Ifx_Ssw_Bmhd bmhd_3_orig =
{
    0x007E,         /* 0x000: .bmi: Boot Mode Index (BMI)                                               */
    0xB359,         /* 0x002: .bmhdid: Boot Mode Header ID (CODE) = B359H                               */
    0xA0000000,     /* 0x004: .stad: User Code start address                                            */
    0x809FE5E2,     /* 0x008: .crc: Check Result for the BMI Header (offset 000H - 007H)                */
    0x7F601A1D,     /* 0x00C: .crcInv: Inverted Check Result for the BMI Header (offset 000H - 007H)    */
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x010: Reserved (0x010 - 0x01F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x020: Reserved (0x020 - 0x02F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x030: Reserved (0x030 - 0x03F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x040: Reserved (0x040 - 0x04F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x050: Reserved (0x050 - 0x05F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x060: Reserved (0x060 - 0x06F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x070: Reserved (0x070 - 0x07F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x080: Reserved (0x080 - 0x08F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x090: Reserved (0x090 - 0x09F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0A0: Reserved (0x0A0 - 0x0AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0B0: Reserved (0x0B0 - 0x0BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0C0: Reserved (0x0C0 - 0x0CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0D0: Reserved (0x0D0 - 0x0DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0E0: Reserved (0x0E0 - 0x0EF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x0F0: Reserved (0x0F0 - 0x0FF)       */
    },
    {
        0x00000000, /* 0x100: .pw0: Password protection word 0 (lsw)                                    */
        0x00000000, /* 0x104: .pw1: Password protection word 1                                          */
        0x00000000, /* 0x108: .pw2: Password protection word 2                                          */
        0x00000000, /* 0x10C: .pw3: Password protection word 3                                          */
        0x00000000, /* 0x110: .pw4: Password protection word 4                                          */
        0x00000000, /* 0x114: .pw5: Password protection word 5                                          */
        0x00000000, /* 0x118: .pw6: Password protection word 6                                          */
        0x00000000, /* 0x11C: .pw7: Password protection word 7 (msw)                                    */
    },
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x120: Reserved (0x120 - 0x12F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x130: Reserved (0x130 - 0x13F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x140: Reserved (0x140 - 0x14F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x150: Reserved (0x150 - 0x15F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x160: Reserved (0x160 - 0x16F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x170: Reserved (0x170 - 0x17F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x180: Reserved (0x180 - 0x18F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x190: Reserved (0x190 - 0x19F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1A0: Reserved (0x1A0 - 0x1AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1B0: Reserved (0x1B0 - 0x1BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1C0: Reserved (0x1C0 - 0x1CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1D0: Reserved (0x1D0 - 0x1DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x1E0: Reserved (0x1E0 - 0x1EF)       */
    },
    0x43211234      /* 0x1F0: .confirmation: 32-bit CODE, (always same)                                 */
};

#if defined(__HIGHTEC__)
#pragma section
#pragma section ".bmhd_3_copy" a
#endif
#if defined(__TASKING__)
#pragma section farrom "bmhd_3_copy"
#endif
#if defined(__DCC__)
#pragma section CONST ".bmhd_3_copy" far-absolute R
#endif
#if defined(__ghs__)
#pragma ghs section rodata= ".bmhd_3_copy"
#endif
const Ifx_Ssw_Bmhd bmhd_3_copy =
{
    0x007E,         /* 0x000: .bmi: Boot Mode Index (BMI)                                               */
    0xB359,         /* 0x002: .bmhdid: Boot Mode Header ID (CODE) = B359H                               */
    0xA0000000,     /* 0x004: .stad: User Code start address                                            */
    0x809FE5E2,     /* 0x008: .crc: Check Result for the BMI Header (offset 000H - 007H)                */
    0x7F601A1D,     /* 0x00C: .crcInv: Inverted Check Result for the BMI Header (offset 000H - 007H)    */
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x010: Reserved (0x010 - 0x01F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x020: Reserved (0x020 - 0x02F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x030: Reserved (0x030 - 0x03F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x040: Reserved (0x040 - 0x04F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x050: Reserved (0x050 - 0x05F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x060: Reserved (0x060 - 0x06F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x070: Reserved (0x070 - 0x07F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x080: Reserved (0x080 - 0x08F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x090: Reserved (0x090 - 0x09F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0A0: Reserved (0x0A0 - 0x0AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0B0: Reserved (0x0B0 - 0x0BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0C0: Reserved (0x0C0 - 0x0CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0D0: Reserved (0x0D0 - 0x0DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x0E0: Reserved (0x0E0 - 0x0EF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000         /* 0x0F0: Reserved (0x0F0 - 0x0FF)       */
    },
    {
        0x00000000, /* 0x100: .pw0: Password protection word 0 (lsw)                                    */
        0x00000000, /* 0x104: .pw1: Password protection word 1                                          */
        0x00000000, /* 0x108: .pw2: Password protection word 2                                          */
        0x00000000, /* 0x10C: .pw3: Password protection word 3                                          */
        0x00000000, /* 0x110: .pw4: Password protection word 4                                          */
        0x00000000, /* 0x114: .pw5: Password protection word 5                                          */
        0x00000000, /* 0x118: .pw6: Password protection word 6                                          */
        0x00000000, /* 0x11C: .pw7: Password protection word 7 (msw)                                    */
    },
    {
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x120: Reserved (0x120 - 0x12F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x130: Reserved (0x120 - 0x13F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x140: Reserved (0x120 - 0x14F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x150: Reserved (0x120 - 0x15F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x160: Reserved (0x120 - 0x16F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x170: Reserved (0x120 - 0x17F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x180: Reserved (0x120 - 0x18F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x190: Reserved (0x120 - 0x19F)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1A0: Reserved (0x120 - 0x1AF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1B0: Reserved (0x120 - 0x1BF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1C0: Reserved (0x120 - 0x1CF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1D0: Reserved (0x120 - 0x1DF)       */
        0x00000000, 0x00000000, 0x00000000, 0x00000000,        /* 0x1E0: Reserved (0x120 - 0x1EF)       */
    },
    0x43211234      /* 0x1F0: .confirmation: 32-bit CODE, (always same)                                 */
};

#if defined(__HIGHTEC__)
#pragma section
#endif
