/**********************************************************************************************************************
 * \file Ifx_Cfg_Ssw.c
 * \brief Configuration file for the Startup Software
 * \copyright Copyright (C) Infineon Technologies AG 2019
 * 
 * Use of this file is subject to the terms of use agreed between (i) you or the company in which ordinary course of 
 * business you are acting and (ii) Infineon Technologies AG or its licensees. If and as long as no such terms of use
 * are agreed, use of this file is subject to following:
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization obtaining a copy of the software and 
 * accompanying documentation covered by this license (the "Software") to use, reproduce, display, distribute, execute,
 * and transmit the Software, and to prepare derivative works of the Software, and to permit third-parties to whom the
 * Software is furnished to do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including the above license grant, this restriction
 * and the following disclaimer, must be included in all copies of the Software, in whole or in part, and all 
 * derivative works of the Software, unless such copies or derivative works are solely in the form of 
 * machine-executable object code generated by a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE 
 * COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN 
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 *********************************************************************************************************************/

/*********************************************************************************************************************/
/*-----------------------------------------------------Includes------------------------------------------------------*/
/*********************************************************************************************************************/
#include "Ifx_Cfg_Ssw.h"
#include "Ifx_Ssw_Infra.h"

/*********************************************************************************************************************/
/*---------------------------------------------Function Implementations----------------------------------------------*/
/*********************************************************************************************************************/
#if defined(__TASKING__)
#pragma optimize RL
#elif defined(__HIGHTEC__)
#pragma GCC optimize ("O1")
#endif

#if (IFX_CFG_SSW_ENABLE_PMS_INIT == 1U)
void Ifx_Ssw_Pms_Init(void)
{
    if (IfxPmsEvr_runInitSequence(&IfxPmsEvr_cfgSequenceDefault) == 0)
    {
        __debug();
        /* Application may have call to error handling here */
    }

    Ifx_Ssw_jumpBackToLink();
}

#if (IFX_CFG_SSW_ENABLE_PMS_INIT_CHECK == 1U)
void Ifx_Ssw_Pms_InitCheck(void)
{

    if (IfxPmsEvr_areInitValuesRight(&IfxPmsEvr_checkRegCfgDefault) == 0)
    {
        __debug();
        /* Application may have call to error handling here */
    }
    Ifx_Ssw_jumpBackToLink();
}
#endif /* End of Ifx_Ssw_Pms_InitCheck() */
#endif /* End of Ifx_Ssw_Pms_Init() */

#if (IFX_CFG_SSW_ENABLE_LBIST == 1)
void Ifx_Ssw_Lbist(void)
{
    if (!IfxScuLbist_isDone())
    {
        if(Ifx_Ssw_isColdPoweronReset())
        {
            IfxScuLbist_triggerInline(&IfxScuLbist_defaultConfig);
        }
    }
    if (!IfxScuLbist_evaluateResult(IfxScuLbist_defaultConfig.signature))
    {
         __debug();
         /* Application may have call to error handling here */
         
         /* Infinite loop to ensure that the error is notified as 'debugger is not connected at this point of time' */
         while(1);
    }

    Ifx_Ssw_jumpBackToLink();
}
#endif

#if defined(__TASKING__)
#pragma endoptimize
#elif defined(__HIGHTEC__)
#pragma GCC reset_options
#endif
