/**
 * \file CompilerGhs.c
 *
 * \copyright Copyright (c) 2013 Infineon Technologies AG. All rights reserved.
 *
 * $Date: 2014-02-27 20:08:40 GMT$
 *
 *                                 IMPORTANT NOTICE
 *
 * Use of this file is subject to the terms of use agreed between (i) you or
 * the company in which ordinary course of business you are acting and (ii)
 * Infineon Technologies AG or its licensees. If and as long as no such terms
 * of use are agreed, use of this file is subject to following:
 *
 * Boost Software License - Version 1.0 - August 17th, 2003
 *
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 *
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer, must
 * be included in all copies of the Software, in whole or in part, and all
 * derivative works of the Software, unless such copies or derivative works are
 * solely in the form of machine-executable object code generated by a source
 * language processor.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

#include "Cpu/Std/Ifx_Types.h"
#include "Compilers.h"

#if defined(__ghs__) && !defined(WIN32)

typedef int ptrdiff_t;
typedef unsigned int syze_t;
typedef signed int signed_size_t;
#define size_t	syze_t

extern void *memcpy(void *s1, const void *s2, syze_t n);
extern void *memset(void *s, int c, syze_t n);

/* rodata is absolute */
typedef const char rodata_ptr[];
# define PIRBASE	0

#define CONST_FUNCP *const

/*!
 * \brief Initializes C variables.
 *
 * This function is called in the startup. This function initialize the all variables in .data section
 * and clears the .bss section
 *
 * Parameters: Nil
 * Return: Nil
 */
void Ifx_C_Init(void)
{
	/*----------------------------------------------------------------------*/
	/*									*/
	/*	Clear BSS							*/
	/*									*/
	/*----------------------------------------------------------------------*/
	    { /* The .secinfo section is in text; declare functions to force PIC */

	#pragma ghs rodata
	    extern rodata_ptr __ghsbinfo_clear;
	#pragma ghs rodata
	    extern rodata_ptr __ghseinfo_clear;

	    void **b = (void **) ((char *)__ghsbinfo_clear);
	    void **e = (void **) ((char *)__ghseinfo_clear);

	    while (b != e) {
		void *		t;			/* target pointer	*/
		ptrdiff_t	v;			/* value to set		*/
		size_t		n;			/* set n bytes		*/
		t = (char *)(*b++);
		v = *((ptrdiff_t *) b); b++;
		n = *((size_t    *) b); b++;
		memset(t, v, n);
	    }
	    }

	/*----------------*/
	/* initialize iob */
	/*----------------*/
	    {
	    #pragma weak __gh_iob_init
	    extern void __gh_iob_init(void);
	    static void (CONST_FUNCP iob_init_funcp)(void) = __gh_iob_init;
	    /* if cciob.c is loaded, initialize _iob for stdin,stdout,stderr */
	    if (iob_init_funcp) __gh_iob_init();
	    }
}


#endif
