setof(string) I = { "t1" , "t2"  , "t3", "t4", "t5"};
float W = 11;
float L[I] = [2.0, 4.5, 5.0, 5.5, 7.5];
float bigM[i in I] = ceil(W/L[i]);
float u[I] =  [0.21+2/300 , 0.491+2/3000 , 0.55 , 0.55 , 0.98+1/300 ];

dvar int+ z[I];
dvar boolean y[I];

dexpr float redcost = 1.0 + 0.1*sum( i in I ) y[i] - sum( i in I ) u[i] * z[i];
minimize redcost;
 
subject to {
	resource: sum ( i in I ) L[i] * z[i] <= W; 
	forall(i in I) {
	  fixcost : z[i] <=  bigM[i]*y[i];
	} 	
}

execute{
  writeln("minimum reduced cost with 11 meters and fixed costs ", redcost);
}
