/*********************************************
 * OPL Model
 * Transportation problem with matrix of vars
 *********************************************/

int Norig =  700;
setof(int) I = asSet(1..Norig);			// origins
int Ndest = 1000;
setof(int) J = asSet(1..Ndest);			// destinations

int randseed=srand(2); 
execute{
  writeln("Solving a random instance with ", Norig, " origins and ", Ndest, " destinations");
  writeln("Using random generator with seed ", randseed);
}

int 	O[i in I] = rand() mod 100; 		// capacity of origin i in I
int 	D[j in J] = rand() mod 100; 		// request of destination j in J
float	C[i in I][j in J] = rand() mod 10 + 0.5;		// unit transportation cost
float	Cost_threshold = 8.0;				// limit for expensive origin-destination links

// for the sake of feasibility
int totO = sum(i in I) O[i];
int totD = sum(j in J) D[j];
execute{
  if ( totD > totO ) O[1] = O[1] + totD - totO;
}

dvar float+ x[I][J];			// *1. defines variables for all o-d pairs

dexpr float z = sum (i in I , j in J) (C[i][j] * x[i][j]);
minimize z;

subject to {
 
forall (i in I, j in J : C[i][j] > Cost_threshold ) {
  no_costy_link: x[i][j] == 0;	// *2. forces transport on expensive o-d pairs to 0
} 
 
forall ( j in J ) {
	request: sum ( i in I : C[i][j] <= Cost_threshold ) x[i][j] >= D[j];
}

forall ( i in I ) {
	capacity: sum ( j in J : C[i][j] <= Cost_threshold ) x[i][j] <= O[i];
}

}

execute {
  for ( var i in I ) {
    for ( var j in J ) {
      if (C[i][j] <= Cost_threshold && x[i][j] > 1e-6) {
        writeln("from ", i, " to ", j, " send ", x[i][j], " (cost = ", C[i][j]*x[i][j],")");
      }
    }
  }
  writeln("Total cost: ",z);
}
