/*********************************************
 * OPL Model
 * Transportation problem with tuples
 *********************************************/

int Norig =  700;
setof(int) I = asSet(1..Norig);			// origins
int Ndest = 1000;
setof(int) J = asSet(1..Ndest);			// destinations

int randseed=srand(2); 
execute{
  writeln("Solving a random instance with ", Norig, " origins and ", Ndest, " destinations");
  writeln("Using random generator with seed ", randseed);
}

int 	O[i in I] = rand() mod 100; 		// capacity of origin i in I
int 	D[j in J] = rand() mod 100; 		// request of destination j in J
float	C[i in I][j in J] = rand() mod 10 + 0.5;		// unit transportation cost
float	Cost_threshold = 8.0;				// defines expensive origin-destination links

// for the sake of feasibility
int totO = sum(i in I) O[i];
int totD = sum(j in J) D[j];
execute{
  if ( totD > totO ) O[1] = O[1] + totD - totO;
}

tuple odpair{	// defines a new type "type" 
	int i;	//origin
	int j;  //destination
}
{odpair} OD = { <i,j> | i in I, j in J : C[i][j] <= Cost_threshold};
						// *0. defines a set of non-expensive o-d pairs

dvar float+ x[OD];		// *1. defines variables for non-expensive o-d pairs only

dexpr float z = sum (<i,j> in OD) (C[i][j] * x[<i,j>]);
minimize z;

subject to {
forall ( j in J ) {
	request: sum ( <i,j>  in OD ) x[<i,j>] >= D[j];
}

forall ( i in I ) {
	capacity: sum ( <i,j>  in OD ) x[<i,j>] <= O[i];
}

}

execute {
  for ( var od in OD ) {
      if (x[od] > 1e-6) {
        writeln("from ", od.i, " to ", od.j, " send ", x[od], " (cost = ", C[od.i][od.j]*x[od],")");
      }
  }
  writeln("Total cost: ",z);   
}