from docplex.mp.model import Model
from random import random

#create random data for given number of origins and destinations
num_origins = int(input("Number of origins ? "))
num_destinations = int(input("Number of destinations ? "))
I=range(0,num_origins)
J=range(0,num_destinations)
cost = {(i,j): random() for i in I for j in J}
origin_capacity = [int(random()*100) for i in I]
destination_request = [int(random()*100) for j in J]
origin_capacity[0] += max(0,sum(destination_request) - sum(origin_capacity))
print(origin_capacity)
print(destination_request)

#we decide to remove expensive Origin-Destinatio links (less variables will be created)
cost_threshold = float(input("consider links with cost up to [0..1] ? "))
ODpairs = [(i, j) for i in I for j in J if cost[(i,j)] <= cost_threshold]

m = Model(name="transportation with OD pairs")
x = m.continuous_var_dict(keys=ODpairs, lb={od: 0 for od in ODpairs}, name = "x")
#notice: the command above is equivalent to the following
# x = {(i,j): m.continuous_var(name='x from {0} to {1}'.format(i,j)) 
#                                for i in I for j in J if cost[i,j] <= cost_threshold}
m.minimize(m.sum(cost[od] * x[od] for od in ODpairs))
for j in J:
 m.add_constraint(m.sum(x[od] for od in ODpairs if od[1] == j) >= destination_request[j])
for i in I:
    m.add_constraint(m.sum(x[od] for od in ODpairs if od[0] == i) <= origin_capacity[i] )

m.print_information()
if m.solve(log_output = False):
    m.print_solution()
else:
    print("The model is infeasible: with the generated data, the selected threshold is too small.")
