from docplex.mp.model import Model
m = Model(name="sample model")
x = m.continuous_var(name="var x")
y = m.continuous_var(name="var y")
my_objective_function = x + y
availability_rhs = 10
m.add_constraint(2*x+y <= availability_rhs)
m.add_constraint(x == 0.25*y)
m.maximize(my_objective_function)
m.print_information() #display information on the model 
m.solve()
m.print_solution()    #display information on the solution