setof(string) I = ...;		// potential antenna's location
int Nareas = ...;
setof(int) J = asSet(1..Nareas);			// areas to be covered

float sigma[I][J] = ...;		// received signal level
float T = ...;  				// signal threshold
int N = ...;					// max num of interfering signals
int M[j in J] = card({ i | i in I : sigma[i][j]>=T });

dvar boolean x[I]; // install antenna in i?
dvar boolean z[J]; // cover area j?

maximize sum(j in J) z[j];
subject to{
  forall(j in J) {
    sum(i in I: sigma[i][j] >= T) x[i] >= z[j];
    sum(i in I: sigma[i][j] >= T) x[i] <= N + M[j]*(1-z[j]);
  }
} 
