/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class BBABAnAn
extends RegularPumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getHTMLTitle() {
        return "<i>bba(ba)<sup>n</sup>a<sup>n-1</sup></i>";
    }

    @Override
    public String getTitle() {
        return "bba(ba)^n a^(n-1)";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"bba(ba)<sup><i>m</i></sup>a<sup><i>m</i>-1</sup>\".  No possible <i>y</i> value among the \"bba(ba)<sup><i>m</i></sup>\" segment is possible to pump, meaning any possible generated string is not in the language.  Thus, the language is not regular.";
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{1, 2});
    }

    @Override
    protected void chooseW() {
        this.w = "bba" + BBABAnAn.pumpString("ba", this.m) + BBABAnAn.pumpString("a", this.m - 1);
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{5, 10};
    }

    @Override
    public boolean isInLang(String s) {
        if (!s.startsWith("bba")) {
            return false;
        }
        String temp = s.substring(3);
        int n = 0;
        while (temp.startsWith("ba")) {
            temp = temp.substring(2);
            ++n;
        }
        while (temp.startsWith("a")) {
            temp = temp.substring(1);
            --n;
        }
        return n == 1 && temp.length() == 0;
    }
}

