/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class AnEven
extends RegularPumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "a^n : n is even";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup></i> : <i>n</i> is even";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a regular language, a valid decomposition exists.  If <i>m</i> " + GREATER_OR_EQ + " 2, " + "the <i>y</i> value \"aa\" will always pump the string.";
    }

    @Override
    protected void chooseW() {
        this.w = this.getM() % 2 == 0 ? AnEven.pumpString("a", this.getM()) : AnEven.pumpString("a", this.getM() + 1);
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 18};
    }

    @Override
    public void chooseDecomposition() {
        int[] nArray = new int[2];
        nArray[1] = 2;
        this.setDecomposition(nArray);
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        String temp = s.length() == 0 ? this.createPumpedString() : s;
        return temp.length() % 2 == 0;
    }
}

