/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class ABnAk
extends RegularPumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "(ab)^n a^k : n > k, k >= 0";
    }

    @Override
    public String getHTMLTitle() {
        return "(<i>ab</i>)<i><sup>n</sup>a<sup>k</sup></i> : <i>n</i> " + GREATER_THAN + " <i>k</i>, <i>k</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 11};
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"(ab)<sup><i>m</i>+1</sup>a<sup><i>m</i></sup>\".  To be in the language, <i>y</i> must possess \"ab\"s, \"ba\"s, \"a\"s, and/or \"b\"s.  Any multiple or combination thereof yields a string that is not in the language when <i>i</i> = 0, meaning this is not a regular language.";
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(ABnAk.pumpString("ab", this.m + 1)) + ABnAk.pumpString("a", this.m);
    }

    @Override
    public void chooseDecomposition() {
        int[] nArray = new int[2];
        nArray[1] = 2;
        this.setDecomposition(nArray);
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    public boolean isInLang(String s) {
        int b;
        char[] list = new char[]{'a'};
        String temp = s;
        while (temp.startsWith("ab")) {
            temp = temp.substring(2);
        }
        if (temp.equals(new String("ab"))) {
            return true;
        }
        if (LemmaMath.isMixture(temp, list)) {
            return false;
        }
        int a = LemmaMath.countInstances(s, 'a');
        return a < 2 * (b = LemmaMath.countInstances(s, 'b'));
    }
}

