/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class WW1WrGrtrThanEq
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "w w1 w^R : |w1| >= 5, w & w1 element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>ww<sub>1</sub>w<sup>R</sup></i> : |<i>w<sub>1</sub></i>| " + GREATER_OR_EQ + " 5, <i>w</i> & <i>w<sub>1</sub></i> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a context-free language, a valid decomposition exists.  For any <i>m</i> value " + GREATER_OR_EQ + " 6, it is possible to assign to both 'w' and 'w<sup>R</sup>' the empty string.  Thus, " + "|'w<sub>1</sub>'| " + GREATER_OR_EQ + " 6.  If |<i>v</i>| = 0 and <i>y</i> is one character from " + "'w<sub>1</sub>', |'w<sub>1</sub>'| " + GREATER_OR_EQ + " 5 for all values of <i>i</i>.";
    }

    @Override
    protected void addCases() {
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(WW1WrGrtrThanEq.pumpString("a", this.m)) + "babab" + WW1WrGrtrThanEq.pumpString("a", this.m);
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{1, 7};
    }

    @Override
    public void chooseDecomposition() {
        int[] nArray = new int[4];
        nArray[0] = this.w.length() / 2;
        nArray[1] = 1;
        this.setDecomposition(nArray);
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        return s.length() >= 5;
    }
}

