/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class WW1WrEquals
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "w w1 w^R : |w| = |w1|, w & w1 element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>ww<sub>1</sub>w<sup>R</sup></i> : |<i>w</i>| = |<i>w<sub>1</sub></i>| , <i>w</i> & <i>w<sub>1</sub></i> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>a<sup><i>m</i></sup>\".  To be in the language with this example, <i>v</i> & <i>y</i> together cannot possess substrings that are from both 'w' and 'w<sup>R</sup>'.  Thus, pumping a substring from either 'w', 'w<sup>1</sup>',  or 'w<sup>R</sup>' will violate the |'w'| = |'w<sup>R</sup>'| equality or cause |'w'| " + NOT_EQUAL + "|'w<sup>1</sup>'|.    Thus, this language is not context-free.";
    }

    @Override
    protected void addCases() {
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    public void chooseDecomposition() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        this.setDecomposition(nArray);
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(WW1WrEquals.pumpString("a", this.m)) + WW1WrEquals.pumpString("b", this.m) + WW1WrEquals.pumpString("a", this.m);
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 10};
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(s, list) || s.length() == 0) {
            return false;
        }
        int front = 0;
        int end = s.length() - 1;
        while (s.charAt(front) == s.charAt(end) && front < end) {
            if (++front != --end - front + 1) continue;
            return true;
        }
        return false;
    }
}

