/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class NaNbNc
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "w element_of {a, b, c}* : na(w) < nb(w) < nc(w)";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w</i> " + ELEMENT_OF + " {<i>a</i>, <i>b</i>, <i>c</i>}* :" + " <i>n<sub>a</sub></i> (<i>w</i>) " + LESS_THAN + " <i>n<sub>b</sub></i> (<i>w</i>) " + LESS_THAN + " <i>n<sub>c</sub></i> (<i>w</i>)";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i>+1</sup>c<sup><i>m</i>+2</sup>\".  With this example, it is impossible to have \"a\"s, \"b\"s, and \"c\"s in both <i>v</i> and <i>y</i> together.  Thus, if <i>i</i> = 0, <i>i</i> = 2, or perhaps both, one of the inequalities will be violated, meaning there is no adequate decomposition.  Thus, this language is not context-free.";
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(NaNbNc.pumpString("a", this.m)) + NaNbNc.pumpString("b", this.m + 1) + NaNbNc.pumpString("c", this.m + 2);
    }

    @Override
    public void chooseDecomposition() {
        int a = LemmaMath.countInstances(this.w, 'a');
        int b = LemmaMath.countInstances(this.w, 'b');
        int c = LemmaMath.countInstances(this.w, 'c');
        if (c > b + 1) {
            int[] nArray = new int[4];
            nArray[0] = this.w.indexOf(99);
            nArray[1] = 1;
            this.setDecomposition(nArray);
        } else if (b > a + 1) {
            int[] nArray = new int[4];
            nArray[0] = this.w.indexOf(98);
            nArray[1] = 1;
            this.setDecomposition(nArray);
        } else {
            super.chooseDecomposition();
        }
    }

    @Override
    public void chooseI() {
        int c = LemmaMath.countInstances(this.getV(), 'c') + LemmaMath.countInstances(this.getY(), 'c');
        this.i = c > 0 ? 0 : 2;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 6};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") > -1 && y.indexOf("b") == -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") > -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[3] = NaNbNc.this.m - 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = NaNbNc.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = NaNbNc.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = NaNbNc.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NaNbNc.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NaNbNc.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") > -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NaNbNc.this.m;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") == -1 && v.indexOf("c") > -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NaNbNc.this.m + 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() == 0 && y.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NaNbNc.this.m;
                nArray[2] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() > 0 && y.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NaNbNc.this.m;
                nArray[1] = 1;
                return nArray;
            }
        });
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b', 'c'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        int a = LemmaMath.countInstances(s, 'a');
        int b = LemmaMath.countInstances(s, 'b');
        int c = LemmaMath.countInstances(s, 'c');
        return a < b && b < c;
    }
}

