/*
 * Decompiled with CFR 0.152.
 */
package pumping;

import gui.environment.Universe;
import java.io.Serializable;
import pumping.Case;
import pumping.LemmaMath;
import pumping.PumpingLemma;

public abstract class RegularPumpingLemma
extends PumpingLemma
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected String x;
    protected String y;
    protected String z;

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    @Override
    public String getDecompositionAsString() {
        String[] s = new String[3];
        int counter = 0;
        int i = 0;
        while (i <= 1) {
            s[i] = this.w.substring(counter, counter + this.myDecomposition[i]);
            counter += this.myDecomposition[i];
            ++i;
        }
        s[2] = this.w.substring(counter);
        i = 0;
        while (i < s.length) {
            if (s[i].length() == 0) {
                s[i] = Universe.curProfile.getEmptyString();
            }
            ++i;
        }
        return "X = " + s[0] + ";   Y = " + s[1] + ";   Z = " + s[2];
    }

    @Override
    public void reset() {
        this.m = -1;
        this.i = -1;
        this.w = "";
        this.x = "";
        this.y = "";
        this.z = "";
    }

    @Override
    public boolean setDecomposition(int[] decomposition, int num) {
        this.i = num;
        return this.setDecomposition(decomposition);
    }

    @Override
    public boolean setDecomposition(int[] decomposition) {
        this.myDecomposition = decomposition;
        int xLength = decomposition[0];
        int yLength = decomposition[1];
        if (xLength + yLength > this.m || yLength < 1 || xLength < 0) {
            return false;
        }
        this.x = this.w.substring(0, xLength);
        this.y = this.w.substring(xLength, xLength + yLength);
        this.z = this.w.substring(xLength + yLength);
        return true;
    }

    @Override
    public String createPumpedString() {
        return String.valueOf(this.x) + RegularPumpingLemma.pumpString(this.y, this.getI()) + this.z;
    }

    @Override
    public int addCase(int[] decomposition, int num) {
        if (!this.setDecomposition(decomposition)) {
            return -1;
        }
        int j = 0;
        while (j < this.myDoneCases.size()) {
            if (((Case)this.myDoneCases.get(j)).isCase(this.y, this.y)) {
                return j;
            }
            ++j;
        }
        j = 0;
        while (j < this.myAllCases.size()) {
            if (((Case)this.myAllCases.get(j)).isCase(this.y, this.y)) {
                Case c = (Case)this.myAllCases.get(j);
                c.setI(num);
                c.setUserInput(decomposition);
                this.myDoneCases.add(c);
                return this.myAllCases.size();
            }
            ++j;
        }
        System.err.println("BUG FOUND: ContextFreePumpingLemma.addCase(int[])");
        return -1;
    }

    @Override
    protected void addCases() {
    }

    @Override
    public boolean replaceCase(int[] decomposition, int num, int index) {
        Case c = (Case)this.myDoneCases.get(index);
        if (c.isCase(this.y, this.y)) {
            c.setI(num);
            c.setUserInput(decomposition);
            return true;
        }
        return false;
    }

    @Override
    public void chooseDecomposition() {
        int x = LemmaMath.fetchRandInt(0, this.getM() - 1);
        this.setDecomposition(new int[]{x, this.getM() - x});
    }
}

