/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Configuration;
import gui.sim.ConfigurationIcon;
import gui.sim.ConfigurationIconFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JToggleButton;

public class ConfigurationButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    protected int state = 0;
    private Configuration config = null;
    private ConfigurationIcon icon = null;
    public static final int NORMAL = 0;
    public static final int ACCEPT = 1;
    public static final int REJECT = 2;
    public static final int FREEZE = 3;
    public static final int FOCUSED = 4;
    private static final String[] TEXT = new String[]{"Normal", "Accept", "Reject", "Freeze", "Focused"};
    public static final Color[] STATE_COLOR = new Color[]{new Color(0, 0, 0, 0), new Color(0, 150, 0, 80), new Color(255, 0, 0, 80), new Color(100, 100, 255, 80), new Color(255, 255, 0, 80)};
    protected static final int PADDING = 5;

    public ConfigurationButton(Configuration config) {
        this(config, 0);
    }

    public ConfigurationButton(Configuration config, int state) {
        this.config = config;
        this.icon = ConfigurationIconFactory.iconForConfiguration(config);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(1);
        this.setState(state);
        this.setPreferredSize(new Dimension(0, 10 + this.icon.getIconHeight()));
    }

    public void setState(int state) {
        if (this.config.isAccept()) {
            state = 1;
        }
        if (state < 0 || state >= TEXT.length) {
            state = 0;
        }
        this.state = state;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(STATE_COLOR[this.state]);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(5, 5);
        this.icon.paintConfiguration(this, (Graphics2D)g, this.getWidth() - 10, this.getHeight() - 10);
        g.translate(-5, -5);
    }
}

