/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;

public class Text {
    public static final Text SPACE = new Text("_");
    protected static final Font FONT = new Font("Courier", 1, 20);
    protected String myText;
    protected Point2D.Double myBottomLeft;

    public Text() {
        this("");
    }

    public Text(String s) {
        this.myText = s;
        this.myBottomLeft = new Point2D.Double(0.0, 0.0);
    }

    public Text(String s, Point2D p) {
        this.myText = s;
        this.myBottomLeft = new Point2D.Double(p.getX(), p.getY());
    }

    public Text(Text t) {
        this.myText = t.myText;
        this.myBottomLeft = new Point2D.Double(t.myBottomLeft.getX(), t.myBottomLeft.getY());
    }

    public void setPos(Point2D p) {
        this.myBottomLeft = new Point2D.Double(p.getX(), p.getY());
    }

    public Point2D.Double getPos() {
        return this.myBottomLeft;
    }

    public void move(Point2D p) {
        this.myBottomLeft.x += p.getX();
        this.myBottomLeft.y += p.getY();
    }

    public double getWidth(Graphics pen) {
        if (this.myText.length() == 0) {
            return 0.0;
        }
        Graphics2D p = (Graphics2D)pen;
        FontRenderContext frc = p.getFontRenderContext();
        TextLayout layout = new TextLayout(this.myText, FONT, frc);
        return layout.getBounds().getWidth();
    }

    public double getHeight(Graphics pen) {
        Graphics2D p = (Graphics2D)pen;
        FontRenderContext frc = p.getFontRenderContext();
        TextLayout layout = new TextLayout("b", FONT, frc);
        return layout.getBounds().getHeight();
    }

    public void paint(Graphics pen) {
        if (this.myText.length() == 0) {
            return;
        }
        Graphics2D p = (Graphics2D)pen;
        FontRenderContext frc = p.getFontRenderContext();
        TextLayout layout = new TextLayout(this.myText, FONT, frc);
        layout.draw(p, (float)this.myBottomLeft.getX(), (float)this.myBottomLeft.getY());
    }

    public static Text getLabel(Graphics pen, Text text, String label) {
        Text temp = new Text(label);
        double x = text.getPos().x + text.getWidth(pen) / 2.0 - temp.getWidth(pen) / 2.0;
        double y = text.getPos().y - 2.0 * text.getHeight(pen);
        temp.setPos(new Point2D.Double(x, y));
        return temp;
    }

    public String toString() {
        return this.myText;
    }
}

