/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import gui.pumping.CompCFPumpingLemmaInputPane;
import gui.pumping.CompRegPumpingLemmaInputPane;
import gui.pumping.HumanCFPumpingLemmaInputPane;
import gui.pumping.HumanRegPumpingLemmaInputPane;
import gui.pumping.PumpingLemmaChooser;
import gui.pumping.PumpingLemmaInputPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pumping.ContextFreePumpingLemma;
import pumping.PumpingLemma;
import pumping.RegularPumpingLemma;

public class PumpingLemmaChooserPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    PumpingLemmaChooser myChooser;
    Environment myEnvironment;
    JRadioButton humanButton;
    JRadioButton computerButton;

    public PumpingLemmaChooserPane(PumpingLemmaChooser plc, Environment env) {
        super.setLayout(new BorderLayout());
        this.myChooser = plc;
        this.myEnvironment = env;
        this.init();
    }

    public Environment getEnvironment() {
        return this.myEnvironment;
    }

    private void init() {
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Then select a lemma."));
        this.add((Component)this.initRadioButtonPanel(), "North");
        int i = 0;
        while (i < this.myChooser.size()) {
            listPanel.add(this.addPumpingLemma(i));
            ++i;
        }
        this.add((Component)listPanel, "Center");
    }

    private JPanel initRadioButtonPanel() {
        ButtonGroup group = new ButtonGroup();
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createTitledBorder("First choose who makes the first move."));
        this.humanButton = new JRadioButton("You go first");
        this.computerButton = new JRadioButton("Computer goes first");
        group.add(this.humanButton);
        group.add(this.computerButton);
        this.humanButton.setSelected(true);
        buttonPanel.add((Component)this.humanButton, "West");
        buttonPanel.add((Component)this.computerButton, "Center");
        return buttonPanel;
    }

    private JPanel addPumpingLemma(int i) {
        PumpingLemma lemma = this.myChooser.get(i);
        JPanel pane = new JPanel(new BorderLayout());
        JEditorPane ep = new JEditorPane("text/html", "<html><body align=center><b><i>L</i> = {" + lemma.getHTMLTitle() + "}</b></body></html>");
        ep.setBackground(this.getBackground());
        ep.setDisabledTextColor(Color.BLACK);
        ep.setEnabled(false);
        pane.add((Component)ep, "Center");
        PumpingLemmaChooseButton button = new PumpingLemmaChooseButton(this.myChooser.get(i), this.myEnvironment, i);
        pane.add((Component)button, "East");
        pane.setBorder(BorderFactory.createEtchedBorder());
        return pane;
    }

    private class PumpingLemmaChooseButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private Environment myEnvironment;
        private PumpingLemma myLemma;
        private int myIndex;

        public PumpingLemmaChooseButton(PumpingLemma pl, Environment env, int index) {
            super("Select");
            this.myEnvironment = env;
            this.myLemma = pl;
            this.myIndex = index;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((PumpingLemmaChooseButton)PumpingLemmaChooseButton.this).PumpingLemmaChooserPane.this.myChooser.reset(PumpingLemmaChooseButton.this.myIndex);
                    ((PumpingLemmaChooseButton)PumpingLemmaChooseButton.this).PumpingLemmaChooserPane.this.myChooser.setCurrent(PumpingLemmaChooseButton.this.myIndex);
                    PumpingLemmaInputPane pane = null;
                    if (((PumpingLemmaChooseButton)PumpingLemmaChooseButton.this).PumpingLemmaChooserPane.this.humanButton.isSelected()) {
                        if (PumpingLemmaChooseButton.this.myLemma instanceof RegularPumpingLemma) {
                            pane = new HumanRegPumpingLemmaInputPane((RegularPumpingLemma)PumpingLemmaChooseButton.this.myLemma);
                        } else if (PumpingLemmaChooseButton.this.myLemma instanceof ContextFreePumpingLemma) {
                            pane = new HumanCFPumpingLemmaInputPane((ContextFreePumpingLemma)PumpingLemmaChooseButton.this.myLemma);
                        }
                    } else if (((PumpingLemmaChooseButton)PumpingLemmaChooseButton.this).PumpingLemmaChooserPane.this.computerButton.isSelected()) {
                        if (PumpingLemmaChooseButton.this.myLemma instanceof RegularPumpingLemma) {
                            pane = new CompRegPumpingLemmaInputPane((RegularPumpingLemma)PumpingLemmaChooseButton.this.myLemma);
                        } else if (PumpingLemmaChooseButton.this.myLemma instanceof ContextFreePumpingLemma) {
                            pane = new CompCFPumpingLemmaInputPane((ContextFreePumpingLemma)PumpingLemmaChooseButton.this.myLemma);
                        }
                    }
                    PumpingLemmaChooseButton.this.myEnvironment.add((Component)pane, "Pumping Lemma", new CriticalTag(){});
                    PumpingLemmaChooseButton.this.myEnvironment.setActive(pane);
                }
            });
        }
    }
}

