/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.HumanFirstPane;
import gui.pumping.SliderPanel;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import pumping.ContextFreePumpingLemma;

public class HumanCFPumpingLemmaInputPane
extends HumanFirstPane {
    private static final long serialVersionUID = 1L;
    private static String I_WIN = "I WIN. Do you want to play again or concede that the language is not context-free?";
    private static String YOU_WIN = "YOU WIN. Does this mean the language is context-free?";
    private SliderPanel myUPanel;
    private SliderPanel myVPanel;

    public HumanCFPumpingLemmaInputPane(ContextFreePumpingLemma l) {
        super(l, "<i>L</i> = {" + l.getHTMLTitle() + "} Context-Free Pumping Lemma");
    }

    @Override
    protected void addDecompPanelGameFeatures(JPanel n) {
        this.decompButtonTitle = new String("Set uvxyz");
        n.setMaximumSize(new Dimension(HumanCFPumpingLemmaInputPane.MAX_SIZE.width, 9 * HumanCFPumpingLemmaInputPane.MAX_SIZE.height / 20));
        n.setPreferredSize(new Dimension(HumanCFPumpingLemmaInputPane.MAX_SIZE.width, 9 * HumanCFPumpingLemmaInputPane.MAX_SIZE.height / 20));
        this.myUPanel = new SliderPanel("u", this);
        this.sliderPanel.add(this.myUPanel);
        this.myVPanel = new SliderPanel("v", this);
        this.sliderPanel.add(this.myVPanel);
        n.setBorder(BorderFactory.createTitledBorder("3. Select decomposition of w into uvxyz."));
    }

    @Override
    protected void mEnteredReset() {
        String s = this.myLemma.getW();
        this.myWDisplay.setText(s);
        this.myUPanel.setSliderMax(s.length());
        this.myUPanel.setText(s);
        this.myUPanel.setVal(0);
        this.myVPanel.setSliderMax(s.length());
        this.myVPanel.setText(s);
        this.myVPanel.setVal(0);
        this.myXPanel.setSliderMax(s.length());
        this.myXPanel.setText(s);
        this.myXPanel.setVal(0);
        this.myYPanel.setSliderMax(s.length());
        this.myYPanel.setText(s);
        this.myYPanel.setVal(0);
        this.refresh();
        this.updateTable();
        this.leftPanel.revalidate();
    }

    @Override
    protected void resetDecompPanel() {
        this.myUPanel.reset();
        this.myVPanel.reset();
        this.myXPanel.reset();
        this.myYPanel.reset();
        this.myZDisplay.setText("");
        this.myZLength.setText("");
        this.updateTable();
    }

    @Override
    protected void refresh() {
        try {
            this.myUPanel.setRange(0, this.myVPanel.getVal());
            this.myVPanel.setRange(this.myUPanel.getVal(), this.myXPanel.getVal());
            this.myXPanel.setRange(this.myVPanel.getVal(), this.myYPanel.getVal());
            this.myYPanel.setRange(this.myXPanel.getVal(), this.myLemma.getW().length());
            this.myZDisplay.setText(this.myLemma.getW().substring(this.myYPanel.getVal()));
            this.myZLength.setText(Integer.toString(this.myZDisplay.getText().length()));
            this.myIDisplay.setText("");
            this.myPumpedStringDisplay.setText("");
            this.myLastWord.setText("");
            this.myCanvas.reset();
            if (this.myUPanel.getVal() > this.myVPanel.getVal()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |v| >= 0");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myVPanel.getVal() > this.myXPanel.getVal()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |x| >= 0");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myXPanel.getVal() > this.myYPanel.getVal()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |y| >= 0");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myYPanel.getVal() - this.myUPanel.getVal() > this.myLemma.getM()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |vxy| <= m");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myVPanel.getVal() - this.myUPanel.getVal() + (this.myYPanel.getVal() - this.myXPanel.getVal()) < 1) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |vy| >= 1");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else {
                this.stageMessages[3].setText("Click \"Set uvxyz\" to set decomposition.");
                this.myDecompButton.setEnabled(true);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void setDecomposition(int[] decomposition) {
        int u = decomposition[0];
        int v = decomposition[1];
        int x = decomposition[2];
        int y = decomposition[3];
        this.myUPanel.setVal(u);
        this.myVPanel.setVal(u + v);
        this.myXPanel.setVal(u + v + x);
        this.myYPanel.setVal(u + v + x + y);
        this.myLemma.setDecomposition(decomposition);
    }

    @Override
    protected void setI() {
        int[] d = new int[]{this.myUPanel.getVal(), this.myVPanel.getVal() - this.myUPanel.getVal(), this.myXPanel.getVal() - this.myVPanel.getVal(), this.myYPanel.getVal() - this.myXPanel.getVal(), this.myLemma.getW().length() - this.myYPanel.getVal()};
        this.myLemma.setDecomposition(d);
        this.myLemma.chooseI();
        if (this.myCases != null) {
            this.myCases.setDecomposition(d);
            this.myCases.setI(this.myLemma.getI());
        }
    }

    @Override
    protected void setCanvas() {
        this.stages[5].setVisible(true);
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getU(), "u");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getV(), "v");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getZ(), "z");
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = this.myLemma.getI();
        nArray[3] = 1;
        nArray[4] = this.myLemma.getI();
        nArray[5] = 1;
        this.myCanvas.moveText(nArray);
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    @Override
    protected String createXYZ() {
        return "<i>uv</i><sup>" + this.myLemma.getI() + "</sup><i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    @Override
    public void update() {
        ContextFreePumpingLemma pl = (ContextFreePumpingLemma)this.myLemma;
        this.stageMessages[0].setText("File loaded.");
        this.updateTopPane(false);
        if (pl.getM() == -1) {
            return;
        }
        this.myMDisplay.setText("" + pl.getM());
        this.myWDisplay.setText(pl.getW());
        int[] decomposition = new int[]{pl.getU().length(), pl.getV().length(), pl.getX().length(), pl.getY().length()};
        this.myUPanel.setText(pl.getW());
        this.myUPanel.setSliderMax(pl.getW().length());
        this.myVPanel.setText(pl.getW());
        this.myVPanel.setSliderMax(pl.getW().length());
        this.myXPanel.setText(pl.getW());
        this.myXPanel.setSliderMax(pl.getW().length());
        this.myYPanel.setText(pl.getW());
        this.myYPanel.setSliderMax(pl.getW().length());
        this.setDecomposition(decomposition, pl.getI());
        if (this.myCases != null) {
            this.myCases.setDecomposition(decomposition);
            this.myCases.setListButtonEnabled(true);
        }
        this.updateTable();
        this.stages[2].setVisible(true);
        this.stages[3].setVisible(true);
        if (pl.getU().length() == 0 && pl.getV().length() == 0 && pl.getX().length() == 0 && pl.getY().length() == 0) {
            this.myDecompButton.setEnabled(false);
        } else {
            this.stages[4].setVisible(true);
            this.stages[5].setVisible(true);
            this.stageMessages[5].setText("Click \"Restart\" to restart the animation.");
            this.stageMessages[5].setVisible(true);
            if (this.myCases != null) {
                this.myCases.setAddReplaceButtonsEnabled(true);
            }
            this.displayIEnd();
            this.myCanvas.setRestartEnabled(true);
        }
    }
}

