/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.State;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.MinimizeTreeNode;
import automata.fsa.Minimizer;
import gui.minimize.ControlPanel;
import gui.minimize.MinimizePane;
import gui.tree.SelectTreeDrawer;
import gui.tree.Trees;
import gui.viewer.SelectionDrawer;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class MinimizeController {
    private MinimizePane view;
    private SelectionDrawer automatonDrawer;
    private SelectTreeDrawer treeDrawer;
    private Minimizer minimizer;
    private MinimizeTreeNode expanding = null;
    private static final String CANT_SPLIT = "This group cannot be split on any terminal!";

    public MinimizeController(MinimizePane view, SelectionDrawer adrawer, SelectTreeDrawer tdrawer, Minimizer minimizer) {
        this.view = view;
        this.automatonDrawer = adrawer;
        this.treeDrawer = tdrawer;
        this.minimizer = minimizer;
    }

    public void stateDown(State state, MouseEvent event) {
        if (state == null) {
            return;
        }
        TreeNode[] selected = this.treeDrawer.getSelected();
        if (selected.length != 1) {
            return;
        }
        this.toggleState((MinimizeTreeNode)selected[0], state);
    }

    public void nodeClicked(MinimizeTreeNode node, MouseEvent event) {
        if (event.isPopupTrigger()) {
            return;
        }
        if (node == null) {
            this.automatonDrawer.clearSelected();
            this.treeDrawer.clearSelected();
            this.view.repaint();
            this.setEnabledness();
            return;
        }
        this.setSelectedStates(node);
        this.setEnabledness();
    }

    void setEnabledness() {
        String es;
        boolean done;
        TreeNode[] selected = this.treeDrawer.getSelected();
        ControlPanel cp = this.view.controlPanel;
        State[] group = this.minimizer.getDistinguishableGroup(this.getAutomaton(), this.getTree());
        boolean bl = done = this.expanding == null && group == null;
        if (done) {
            cp.finishAction.setEnabled(true);
            selected = new TreeNode[]{};
            cp.finishAction.setTip("Proceed to automaton building phase.");
        } else {
            cp.finishAction.setEnabled(false);
            cp.finishAction.setTip("Can't proceed.  Distinguishable groups still exist.");
        }
        if (selected.length != 1) {
            String s = done ? "Tree is complete.  No action needed." : "This requires one node be selected.";
            cp.setTerminalAction.setEnabled(false);
            cp.setTerminalAction.setTip(s);
            cp.autoPartitionAction.setEnabled(false);
            cp.autoPartitionAction.setTip(s);
            cp.completeSubtreeAction.setEnabled(false);
            cp.autoPartitionAction.setTip(s);
            cp.removeAction.setEnabled(false);
            cp.autoPartitionAction.setTip(s);
        }
        if (this.expanding == null) {
            cp.checkNodeAction.setEnabled(false);
            cp.checkNodeAction.setTip("No group is being expanded.");
            cp.addChildAction.setEnabled(false);
            cp.addChildAction.setTip("No group is being expanded.");
        } else {
            String es2 = this.minimizer.getString(this.expanding.getStates());
            cp.checkNodeAction.setEnabled(true);
            cp.checkNodeAction.setTip("Press to check expansion of group " + es2 + ".");
            cp.addChildAction.setEnabled(true);
            cp.addChildAction.setTip("Add another partition to " + es2 + ".");
        }
        if (selected.length != 1) {
            return;
        }
        MinimizeTreeNode node = (MinimizeTreeNode)selected[0];
        if (this.expanding != null && node.getParent() == this.expanding) {
            es = this.minimizer.getString(this.expanding.getStates());
            cp.removeAction.setEnabled(true);
            cp.removeAction.setTip("Remove this partition from " + es + ".");
        } else {
            cp.removeAction.setEnabled(false);
            cp.removeAction.setTip("We're not expanding the parent.  Cannot delete.");
        }
        if (this.expanding == null) {
            String completeS = this.minimizer.getString(node.getStates());
            cp.completeSubtreeAction.setTip("Complete all distinguishable groups descending from group " + completeS + ".");
            cp.completeSubtreeAction.setEnabled(true);
        } else {
            es = this.minimizer.getString(this.expanding.getStates());
            cp.completeSubtreeAction.setEnabled(false);
            cp.completeSubtreeAction.setTip("Must finish group " + es + " before we do this.");
        }
        if (this.expanding == node) {
            cp.setTerminalAction.setEnabled(true);
            cp.setTerminalAction.setTip("Set this group to expand on a different terminal.");
            cp.autoPartitionAction.setEnabled(true);
            cp.autoPartitionAction.setTip("Complete the expansion of this group on " + node.getTerminal() + ".");
        } else if (this.expanding == null) {
            if (node.getChildCount() == 0) {
                cp.setTerminalAction.setEnabled(true);
                cp.setTerminalAction.setTip("Attempt to expand the group on a terminal.");
                cp.autoPartitionAction.setEnabled(true);
                cp.autoPartitionAction.setTip("Complete the expansion of this group on some terminal.");
            } else {
                String s = "This group is already expanded.";
                cp.setTerminalAction.setEnabled(false);
                cp.setTerminalAction.setTip(s);
                cp.autoPartitionAction.setEnabled(false);
                cp.autoPartitionAction.setTip(s);
            }
        } else {
            es = this.minimizer.getString(this.expanding.getStates());
            cp.setTerminalAction.setEnabled(false);
            cp.setTerminalAction.setTip("Cannot expand another group while " + es + " is in progress.");
            cp.autoPartitionAction.setEnabled(false);
            cp.autoPartitionAction.setTip("Cannot expand another group while " + es + " is in progress.");
            return;
        }
    }

    public boolean splitOnTerminal(MinimizeTreeNode node) {
        if (!this.canExpand(node)) {
            return false;
        }
        if (node.getParent() == null) {
            JOptionPane.showMessageDialog(this.view, "You can't split the root!");
            return false;
        }
        MinimizeTreeNode[] children = this.killChildren(node);
        if (!this.minimizer.isSplittable(node.getStates(), this.getAutomaton(), this.getTree())) {
            JOptionPane.showMessageDialog(this.view, CANT_SPLIT);
            this.addChildren(node, children);
            return false;
        }
        String terminal = JOptionPane.showInputDialog(this.view, (Object)"What terminal?");
        if (terminal == null) {
            this.addChildren(node, children);
            return false;
        }
        if (!this.minimizer.isSplittableOnTerminal(node.getStates(), terminal, this.getAutomaton(), this.getTree())) {
            JOptionPane.showMessageDialog(this.view, "The group doesn't split on that terminal!");
            this.addChildren(node, children);
            return false;
        }
        node.setTerminal(terminal);
        this.expanding = node;
        this.addChild(node);
        this.addChild(node);
        this.view.repaint();
        return true;
    }

    public void nodeDown(MinimizeTreeNode node, MouseEvent event) {
        if (node == null) {
            return;
        }
    }

    public void toggleState(MinimizeTreeNode node, State state) {
        if (!this.canModifyChild((MinimizeTreeNode)node.getParent())) {
            return;
        }
        try {
            MinimizeTreeNode parent = (MinimizeTreeNode)node.getParent();
            if (!Arrays.asList(parent.getStates()).contains(state)) {
                JOptionPane.showMessageDialog(this.view, "The group being split does not contain state " + state.getID() + "!");
                return;
            }
            TreeNode[] children = Trees.children(parent);
            int i = 0;
            while (i < children.length) {
                List<State> c;
                MinimizeTreeNode child = (MinimizeTreeNode)children[i];
                if (child != node && (c = Arrays.asList(child.getStates())).contains(state)) {
                    JOptionPane.showMessageDialog(this.view, "Another partition already contains state " + state.getID() + "!");
                    return;
                }
                ++i;
            }
        }
        catch (NullPointerException e) {
            JOptionPane.showMessageDialog(this.view, "One cannot change the states in the root!");
        }
        State[] states = node.getStates();
        LinkedList<State> list = new LinkedList<State>(Arrays.asList(states));
        if (list.contains(state)) {
            list.remove(state);
        } else {
            list.add(state);
        }
        states = list.toArray(new State[0]);
        node.setUserObject(states);
        this.setSelectedStates(node);
        this.view.repaint();
    }

    private void split(MinimizeTreeNode node) {
        this.expanding = node;
        this.killChildren(node);
        ArrayList<State[]> groups = this.minimizer.splitOnTerminal(node.getStates(), node.getTerminal(), this.getAutomaton(), this.getTree());
        Iterator<State[]> it = groups.iterator();
        while (it.hasNext()) {
            this.addChild(node, it.next());
        }
        this.expanding = null;
    }

    public void splitWithInput(MinimizeTreeNode node) {
        if (!this.canExpand(node)) {
            return;
        }
        if (node.getTerminal().equals("")) {
            if (!this.minimizer.isSplittable(node.getStates(), this.getAutomaton(), this.getTree())) {
                JOptionPane.showMessageDialog(this.view, CANT_SPLIT);
                return;
            }
            if (!this.splitOnTerminal(node)) {
                return;
            }
        }
        this.split(node);
    }

    public void splitWithoutInput(MinimizeTreeNode node) {
        if (!this.canExpand(node)) {
            return;
        }
        if (node.getTerminal().equals("")) {
            if (!this.minimizer.isSplittable(node.getStates(), this.getAutomaton(), this.getTree())) {
                JOptionPane.showMessageDialog(this.view, CANT_SPLIT);
                return;
            }
            node.setTerminal(this.minimizer.getTerminalToSplit(node.getStates(), this.getAutomaton(), this.getTree()));
        }
        this.split(node);
    }

    public void splitSubtree(MinimizeTreeNode root) {
        TreeNode[] children;
        if (this.expanding != null) {
            JOptionPane.showMessageDialog(this.view, "We must finish expanding group " + this.minimizer.getString(this.expanding.getStates()) + "\nbefore we expand anything else.");
        }
        if ((children = Trees.children(root)).length == 0) {
            if (!this.minimizer.isSplittable(root.getStates(), this.getAutomaton(), this.getTree())) {
                root.setTerminal("");
                return;
            }
            root.setTerminal(this.minimizer.getTerminalToSplit(root.getStates(), this.getAutomaton(), this.getTree()));
            this.split(root);
            children = Trees.children(root);
        }
        int i = 0;
        while (i < children.length) {
            this.splitSubtree((MinimizeTreeNode)children[i]);
            ++i;
        }
    }

    private void setSelectedStates(MinimizeTreeNode node) {
        this.automatonDrawer.clearSelected();
        State[] states = node.getStates();
        int i = 0;
        while (i < states.length) {
            this.automatonDrawer.addSelected(states[i]);
            ++i;
        }
        this.treeDrawer.clearSelected();
        this.treeDrawer.setSelected(node, true);
        this.view.repaint();
    }

    private MinimizeTreeNode[] killChildren(MinimizeTreeNode node) {
        TreeNode[] children = Trees.children(node);
        MinimizeTreeNode[] toReturn = new MinimizeTreeNode[children.length];
        int i = 0;
        while (i < children.length) {
            toReturn[i] = (MinimizeTreeNode)children[i];
            this.getTree().removeNodeFromParent(toReturn[i]);
            ++i;
        }
        return toReturn;
    }

    private DefaultTreeModel getTree() {
        return (DefaultTreeModel)this.treeDrawer.getModel();
    }

    private FiniteStateAutomaton getAutomaton() {
        return (FiniteStateAutomaton)this.automatonDrawer.getAutomaton();
    }

    public MinimizeTreeNode addChild() {
        return this.addChild(this.expanding);
    }

    public MinimizeTreeNode addChild(MinimizeTreeNode parent) {
        if (parent.getStates().length <= parent.getChildCount()) {
            JOptionPane.showMessageDialog(this.view, "A group cannot have more partitions than elements!");
            return null;
        }
        return this.addChild(parent, new State[0]);
    }

    public MinimizeTreeNode addChild(MinimizeTreeNode parent, State[] group) {
        if (!this.canModifyChild(parent)) {
            return null;
        }
        MinimizeTreeNode node = new MinimizeTreeNode(group);
        this.getTree().insertNodeInto(node, parent, parent.getChildCount());
        this.view.repaint();
        return node;
    }

    private void addChildren(MinimizeTreeNode parent, MinimizeTreeNode[] children) {
        int i = 0;
        while (i < children.length) {
            this.getTree().insertNodeInto(children[i], parent, parent.getChildCount());
            ++i;
        }
    }

    public void removeNode(MinimizeTreeNode node) {
        MinimizeTreeNode parent = (MinimizeTreeNode)node.getParent();
        if (parent == null) {
            JOptionPane.showMessageDialog(this.view, "One can't remove the root!");
            return;
        }
        if (!this.canModifyChild(parent)) {
            return;
        }
        this.getTree().removeNodeFromParent(node);
        this.view.repaint();
    }

    public boolean check() {
        if (this.expanding == null) {
            return false;
        }
        return this.check(this.expanding);
    }

    public boolean check(MinimizeTreeNode node) {
        MinimizeTreeNode[] children = this.killChildren(node);
        if (!this.minimizer.isSplittable(node.getStates(), this.getAutomaton(), this.getTree())) {
            if (node.getTerminal().equals("") && children.length == 0) {
                JOptionPane.showMessageDialog(this.view, "This group is correct!");
                this.addChildren(node, children);
                return true;
            }
            this.addChildren(node, children);
            JOptionPane.showMessageDialog(this.view, "This group is unsplittable, so it must\nhave no terminal, and no partitions.");
            return false;
        }
        HashSet<HashSet<State>> userPartitions = new HashSet<HashSet<State>>();
        int i = 0;
        while (i < children.length) {
            MinimizeTreeNode child = children[i];
            if (child.getStates().length == 0) {
                this.addChildren(node, children);
                JOptionPane.showMessageDialog(this.view, "One of the partitions is empty!");
                return false;
            }
            userPartitions.add(new HashSet<State>(Arrays.asList(child.getStates())));
            ++i;
        }
        HashSet<HashSet<State>> realPartitions = new HashSet<HashSet<State>>();
        ArrayList<State[]> groups = this.minimizer.splitOnTerminal(node.getStates(), node.getTerminal(), this.getAutomaton(), this.getTree());
        this.addChildren(node, children);
        Iterator<State[]> it = groups.iterator();
        while (it.hasNext()) {
            realPartitions.add(new HashSet<State>(Arrays.asList(it.next())));
        }
        if (!realPartitions.equals(userPartitions)) {
            JOptionPane.showMessageDialog(this.view, "The parititons are wrong!");
            return false;
        }
        JOptionPane.showMessageDialog(this.view, "The expansion is correct!");
        this.expanding = null;
        return true;
    }

    private boolean canExpand(MinimizeTreeNode node) {
        if (this.expanding == null && node.getChildCount() > 0) {
            JOptionPane.showMessageDialog(this.view, "This group has already been expanded.");
            return false;
        }
        if (this.expanding == null || this.expanding == node) {
            return true;
        }
        JOptionPane.showMessageDialog(this.view, "We're already expanding the group " + this.minimizer.getString(this.expanding.getStates()) + "!");
        return false;
    }

    private boolean canModifyChild(MinimizeTreeNode parent) {
        if (this.expanding == parent && parent != null) {
            return true;
        }
        if (parent == null) {
            JOptionPane.showMessageDialog(this.view, "The root cannot be changed!");
            return false;
        }
        JOptionPane.showMessageDialog(this.view, "We cannot modify the partitions of a\ngroup we're not expanding!" + (this.expanding == null ? "" : "\nWe are expanding group " + this.minimizer.getString(this.expanding.getStates())));
        return false;
    }

    public boolean finished() {
        if (this.expanding != null) {
            JOptionPane.showMessageDialog(this.view, "We are expanding group " + this.minimizer.getString(this.expanding.getStates()) + "\nand so are not done.");
            return false;
        }
        State[] group = this.minimizer.getDistinguishableGroup(this.getAutomaton(), this.getTree());
        if (group == null) {
            this.view.beginMinimizedAutomaton(this.getAutomaton(), this.getTree());
            return true;
        }
        JOptionPane.showMessageDialog(this.view, "The tree is unfinished.  Group " + this.minimizer.getString(group) + " may be partitioned.");
        return false;
    }
}

