/*
 * Decompiled with CFR 0.152.
 */
package gui.lsystem;

import grammar.Production;
import grammar.UnboundGrammar;
import grammar.lsystem.LSystem;
import gui.HighlightTable;
import gui.TableTextSizeSlider;
import gui.TextFieldSizeSlider;
import gui.grammar.GrammarInputPane;
import gui.lsystem.LSystemInputEvent;
import gui.lsystem.LSystemInputListener;
import gui.lsystem.ParameterTableModel;
import gui.lsystem.Renderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class LSystemInputPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final LSystem SYSTEM = new LSystem();
    private JTextField axiomField;
    private GrammarInputPane productionInputPane;
    private ParameterTableModel parameterModel;
    private HighlightTable parameterTable;
    private Set<LSystemInputListener> lSystemInputListeners = new HashSet<LSystemInputListener>();
    private LSystemInputEvent reusedEvent = new LSystemInputEvent(this);
    private LSystem cachedSystem = null;

    public LSystemInputPane() {
        this(SYSTEM);
    }

    public LSystemInputPane(LSystem lsystem) {
        super(new BorderLayout());
        this.initializeStructures(lsystem);
        this.initializeListener();
        this.initializeView();
    }

    private void initializeStructures(LSystem lsystem) {
        this.axiomField = new JTextField(LSystemInputPane.listAsString(lsystem.getAxiom()));
        Set<String> replacements = lsystem.getSymbolsWithReplacements();
        Iterator<String> it = replacements.iterator();
        UnboundGrammar g = new UnboundGrammar();
        while (it.hasNext()) {
            String symbol = it.next();
            List<String>[] r = lsystem.getReplacements(symbol);
            int i = 0;
            while (i < r.length) {
                Production p = new Production(symbol, LSystemInputPane.listAsString(r[i]));
                g.addProduction(p);
                ++i;
            }
        }
        this.productionInputPane = new GrammarInputPane(g);
        this.parameterModel = new ParameterTableModel(lsystem.getValues());
        this.cachedSystem = lsystem;
    }

    private void initializeView() {
        JPanel axiomView = new JPanel(new BorderLayout());
        axiomView.add((Component)new JLabel("Axiom: "), "West");
        axiomView.add((Component)this.axiomField, "Center");
        axiomView.add((Component)new TextFieldSizeSlider(this.axiomField, 0, "Input Field Text Size"), "South");
        this.add((Component)axiomView, "North");
        this.parameterTable = new HighlightTable(this.parameterModel);
        JPanel parameterPanel = new JPanel();
        parameterPanel.setLayout(new BorderLayout());
        parameterPanel.add((Component)this.parameterTable, "Center");
        parameterPanel.add((Component)new TableTextSizeSlider(this.parameterTable, 0), "North");
        JScrollPane scroller = new JScrollPane(parameterPanel);
        Dimension bestSize = new Dimension(400, 200);
        this.productionInputPane.setPreferredSize(bestSize);
        scroller.setPreferredSize(bestSize);
        JSplitPane split = new JSplitPane(0, this.productionInputPane, scroller);
        this.add((Component)split, "Center");
        this.parameterTable.setShowGrid(true);
        this.parameterTable.setGridColor(Color.lightGray);
        scroller.setVerticalScrollBarPolicy(22);
        final JPopupMenu menu = new JPopupMenu();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LSystemInputPane.this.setEditing(e.getActionCommand());
            }
        };
        String[] words = Renderer.ASSIGN_WORDS.toArray(new String[0]);
        int i = 0;
        while (i < words.length) {
            menu.add(words[i]).addActionListener(listener);
            ++i;
        }
        JPanel c = new JPanel();
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                menu.show((Component)e.getSource(), e.getPoint().x, e.getPoint().y);
            }
        });
        scroller.setCorner("UPPER_RIGHT_CORNER", c);
    }

    public void initializeListener() {
        this.axiomField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LSystemInputPane.this.fireLSystemInputEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LSystemInputPane.this.fireLSystemInputEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LSystemInputPane.this.fireLSystemInputEvent();
            }
        });
        TableModelListener tml = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                LSystemInputPane.this.fireLSystemInputEvent();
            }
        };
        this.parameterModel.addTableModelListener(tml);
        this.productionInputPane.getTable().getModel().addTableModelListener(tml);
    }

    public static String listAsString(List<String> list) {
        Iterator<String> it = list.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(' ');
            sb.append(it.next());
        }
        return sb.toString();
    }

    public LSystem getLSystem() {
        if (this.productionInputPane.getTable().getCellEditor() != null) {
            this.productionInputPane.getTable().getCellEditor().stopCellEditing();
        }
        if (this.parameterTable.getCellEditor() != null) {
            this.parameterTable.getCellEditor().stopCellEditing();
        }
        try {
            if (this.cachedSystem == null) {
                this.cachedSystem = new LSystem(this.axiomField.getText(), this.productionInputPane.getGrammar(UnboundGrammar.class), this.parameterModel.getParameters());
            }
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "L-System Error", 0);
        }
        return this.cachedSystem;
    }

    public void addLSystemInputListener(LSystemInputListener listener) {
        this.lSystemInputListeners.add(listener);
    }

    public void removeLSystemInputListener(LSystemInputListener listener) {
        this.lSystemInputListeners.remove(listener);
    }

    protected void fireLSystemInputEvent() {
        this.cachedSystem = null;
        Iterator<LSystemInputListener> it = this.lSystemInputListeners.iterator();
        while (it.hasNext()) {
            it.next().lSystemChanged(this.reusedEvent);
        }
    }

    private void setEditing(String item) {
        int i = 0;
        while (i < this.parameterModel.getRowCount()) {
            if (this.parameterModel.getValueAt(i, 0).equals(item)) break;
            ++i;
        }
        if (i == this.parameterModel.getRowCount()) {
            this.parameterModel.setValueAt(item, --i, 0);
        }
        int column = this.parameterTable.convertColumnIndexToView(1);
        this.parameterTable.editCellAt(i, column);
        this.parameterTable.requestFocus();
    }
}

