/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.BruteParser;
import grammar.parse.BruteParserEvent;
import grammar.parse.BruteParserListener;
import gui.TextFieldSizeSlider;
import gui.environment.GrammarEnvironment;
import gui.grammar.parse.BruteParsePane;
import gui.grammar.parse.UnrestrictedTreePanel;
import gui.sim.multiple.InputTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.tree.TreeNode;

public class TMBruteParsePane
extends BruteParsePane {
    private static final long serialVersionUID = 1L;
    private Grammar myTrimmedGrammar;

    public TMBruteParsePane(GrammarEnvironment environment, Grammar orig, Grammar trim, HashMap<String, String> map, InputTableModel model) {
        super(environment, orig);
        this.treePanel = new UnrestrictedTreePanel(this, map);
        this.initView();
        this.myTrimmedGrammar = trim;
        this.myTrimmedGrammar.setStartVariable("S");
        this.myModel = model;
    }

    @Override
    protected JTable initParseTable() {
        return null;
    }

    @Override
    protected JPanel initInputPanel() {
        JPanel bigger = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 1;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Input"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        panel.add((Component)this.inputField, c);
        this.inputField.addActionListener(this.startAction);
        panel.add((Component)this.progress, c);
        panel.add((Component)new TextFieldSizeSlider(this.inputField, 0, "Input Field Text Size"), c);
        bigger.add((Component)panel, "Center");
        bigger.add((Component)this.initInputToolbar(), "North");
        return bigger;
    }

    @Override
    public void parseMultiple() {
        String[][] inputs = this.myModel.getInputs();
        int size = 1;
        if (this.environment.myObjects != null) {
            size = this.environment.myObjects.size();
        }
        int uniqueInputs = inputs.length / size;
        Grammar currentGram = this.grammar;
        if (this.environment.myObjects != null) {
            currentGram = (Grammar)this.environment.myObjects.get(0);
        }
        if (this.row < inputs.length - 1) {
            ++this.row;
            if (this.row % uniqueInputs == 0 && this.environment.myObjects != null) {
                this.grammar = currentGram = (Grammar)this.environment.myObjects.get(this.row / uniqueInputs);
            }
            this.parser = BruteParser.get(this.myTrimmedGrammar, inputs[this.row][0]);
            this.parseInput(inputs[this.row][0], this.parser);
        }
    }

    @Override
    public void parseInput(String string, BruteParser newParser) {
        if (string.equals("")) {
            return;
        }
        if (newParser == null) {
            try {
                this.parser = BruteParser.get(this.myTrimmedGrammar, string);
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Bad Input", 0);
                return;
            }
        } else {
            this.parser = newParser;
        }
        final Timer timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TMBruteParsePane.this.parser == null) {
                    return;
                }
                String nodeCount = "Nodes generated: " + TMBruteParsePane.this.parser.getTotalNodeCount() + "(" + TMBruteParsePane.this.parser.getConsiderationNodeCount() + ")";
                TMBruteParsePane.this.progress.setText("Parser running.  " + nodeCount);
            }
        });
        this.parser.addBruteParserListener(new BruteParserListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bruteParserStateChange(BruteParserEvent e) {
                BruteParser bruteParser = e.getParser();
                synchronized (bruteParser) {
                    String nodeCount = String.valueOf(e.getParser().getTotalNodeCount()) + " nodes generated.";
                    String status = null;
                    switch (e.getType()) {
                        case 0: {
                            TMBruteParsePane.this.pauseResumeAction.setEnabled(true);
                            TMBruteParsePane.this.pauseResumeAction.putValue("Name", "Pause");
                            timer.start();
                            status = "Parser started.";
                            TMBruteParsePane.this.statusDisplay.setText(status);
                            break;
                        }
                        case 3: {
                            TMBruteParsePane.this.pauseResumeAction.setEnabled(false);
                            timer.stop();
                            status = "String rejected.";
                            if (TMBruteParsePane.this.myModel == null) break;
                            String[][] inputs = TMBruteParsePane.this.myModel.getInputs();
                            int size = 1;
                            if (TMBruteParsePane.this.environment.myObjects != null) {
                                size = TMBruteParsePane.this.environment.myObjects.size();
                            }
                            int uniqueInputs = inputs.length / size;
                            TMBruteParsePane.this.myModel.setResult(TMBruteParsePane.this.row, "Reject", null, TMBruteParsePane.this.environment.myTransducerStrings, TMBruteParsePane.this.row % uniqueInputs * 2);
                            TMBruteParsePane.this.parseMultiple();
                            break;
                        }
                        case 1: {
                            timer.stop();
                            TMBruteParsePane.this.pauseResumeAction.putValue("Name", "Resume");
                            TMBruteParsePane.this.pauseResumeAction.setEnabled(true);
                            status = "Parser paused.";
                            TMBruteParsePane.this.statusDisplay.setText(status);
                            break;
                        }
                        case 2: {
                            TMBruteParsePane.this.pauseResumeAction.setEnabled(false);
                            TMBruteParsePane.this.stepAction.setEnabled(true);
                            timer.stop();
                            status = "String accepted!";
                            if (TMBruteParsePane.this.myModel == null) break;
                            TMBruteParsePane.this.myModel.setResult(TMBruteParsePane.this.row, "Accept", null, TMBruteParsePane.this.environment.myTransducerStrings, TMBruteParsePane.this.row);
                            TMBruteParsePane.this.parseMultiple();
                        }
                    }
                    TMBruteParsePane.this.progress.setText(String.valueOf(status) + "  " + nodeCount);
                    if (TMBruteParsePane.this.parser.isFinished()) {
                        if (!e.isAccept()) {
                            TMBruteParsePane.this.treePanel.setAnswer(null);
                            TMBruteParsePane.this.treePanel.repaint();
                            TMBruteParsePane.this.stepAction.setEnabled(false);
                            TMBruteParsePane.this.statusDisplay.setText("Try another string.");
                            return;
                        }
                        TreeNode node = e.getParser().getAnswer();
                        while ((node = node.getParent()) != null) {
                        }
                        TMBruteParsePane.this.statusDisplay.setText("Press step to show derivations.");
                        TMBruteParsePane.this.treePanel.setAnswer(e.getParser().getAnswer());
                        TMBruteParsePane.this.treePanel.repaint();
                    }
                }
            }
        });
        this.parser.start();
    }

    @Override
    public void input(String string) {
        if (this.parser != null) {
            this.parser.pause();
        }
        this.parseInput(string, null);
    }

    @Override
    protected String[] getViewChoices() {
        return new String[]{"Noninverted Tree", "Derivation Table"};
    }

    @Override
    public boolean step() {
        boolean worked = false;
        if (this.treePanel.next()) {
            this.stepAction.setEnabled(false);
            worked = true;
        }
        this.treePanel.repaint();
        return worked;
    }

    @Override
    protected JComponent initTreePanel() {
        return this.treePanel;
    }
}

