/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import gui.environment.Universe;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class FirstFollowModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] variables;
    private String[] terminals;
    private String[] firstSets;
    private String[] followSets;
    private boolean[] canEditColumn = new boolean[3];
    public static String LAMBDA = Universe.curProfile.getEmptyString();
    public static String[] COLUMN_NAMES = new String[]{" ", "FIRST", "FOLLOW"};

    public FirstFollowModel(Grammar grammar) {
        this.variables = grammar.getVariables();
        Arrays.sort(this.variables);
        this.terminals = grammar.getTerminals();
        this.firstSets = new String[this.variables.length];
        this.followSets = new String[this.variables.length];
        Arrays.fill(this.firstSets, "");
        Arrays.fill(this.followSets, "");
    }

    public Map<String, Set<String>> getFirst() {
        return null;
    }

    public Map<String, Set<String>> getFollow() {
        return null;
    }

    public void setCanEditFirst(boolean canEdit) {
        this.canEditColumn[1] = canEdit;
    }

    public void setCanEditFollow(boolean canEdit) {
        this.canEditColumn[2] = canEdit;
    }

    @Override
    public int getRowCount() {
        return this.variables.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.variables[row];
            }
            case 1: {
                return this.firstSets[row];
            }
            case 2: {
                return this.followSets[row];
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.canEditColumn[column];
    }

    public Set<String> getSet(int row, int column) {
        String s = (String)this.getValueAt(row, column);
        TreeSet<String> set = new TreeSet<String>();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '!') {
                set.add("");
            } else {
                set.add(s.substring(i, i + 1));
            }
            ++i;
        }
        return set;
    }

    private String removeDuplicateCharacters(String s) {
        HashSet<Character> characters = new HashSet<Character>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            Character c = new Character(s.charAt(i));
            if (characters.add(c)) {
                sb.append(c.charValue());
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 0: {
                this.variables[row] = (String)value;
                break;
            }
            case 1: {
                this.firstSets[row] = this.removeDuplicateCharacters((String)value);
                break;
            }
            case 2: {
                this.followSets[row] = this.removeDuplicateCharacters((String)value);
            }
        }
    }

    public void setSet(Set<String> set, int row, int column) {
        StringBuffer sb = new StringBuffer();
        for (String element : set) {
            if (element.length() == 0) {
                element = "!";
            }
            sb.append(element);
        }
        this.setValueAt(sb.toString(), row, column);
    }
}

