/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.State;
import automata.Transition;
import automata.pda.PDAToCFGConverter;
import automata.pda.PushdownAutomaton;
import grammar.Grammar;
import grammar.Production;
import grammar.cfg.ContextFreeGrammar;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.GrammarCreationException;
import gui.viewer.SelectionDrawer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class PDAConvertController
extends ConvertController {
    private PDAToCFGConverter converter = new PDAToCFGConverter();

    public PDAConvertController(ConvertPane pane, SelectionDrawer drawer, PushdownAutomaton automaton) {
        super(pane, drawer, automaton);
        this.converter.initializeConverter();
        this.fillMap();
    }

    @Override
    protected Production[] getProductions(State state) {
        return new Production[0];
    }

    @Override
    protected Production[] getProductions(Transition transition) {
        return this.converter.createProductionsForTransition(transition, this.getAutomaton()).toArray(new Production[0]);
    }

    @Override
    protected Grammar getGrammar() {
        int oldNumProductions = this.getModel().getProductions().length;
        this.converter.purgeProductions(this.getAutomaton(), this.getModel());
        if (oldNumProductions != this.getModel().getProductions().length && this.converter.numberVariables() > 26) {
            throw new GrammarCreationException("Your list of rules has been trimmed, but there are still more variables than can be uniquely represented.");
        }
        if (this.converter.numberVariables() > 26) {
            throw new GrammarCreationException("There are more variables than can be uniquely represented.");
        }
        if (oldNumProductions != this.getModel().getProductions().length) {
            JOptionPane.showMessageDialog(null, "Your list of rules has been trimmed.");
        }
        int rows = this.getModel().getRowCount();
        ContextFreeGrammar grammar = new ContextFreeGrammar();
        grammar.setStartVariable("S");
        ArrayList<Production> productions = new ArrayList<Production>();
        int i = 0;
        while (i < rows) {
            Production production = this.getModel().getProduction(i);
            if (production != null) {
                production = this.converter.getSimplifiedProduction(production);
                productions.add(production);
            }
            ++i;
        }
        Collections.sort(productions, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Production p1 = (Production)o1;
                Production p2 = (Production)o2;
                if ("S".equals(p1.getLHS())) {
                    if (p1.getLHS().equals(p2.getLHS())) {
                        return 0;
                    }
                    return -1;
                }
                if ("S".equals(p2.getLHS())) {
                    return 1;
                }
                return p2.getLHS().compareTo(p1.getRHS());
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        Iterator it = productions.iterator();
        while (it.hasNext()) {
            grammar.addProduction((Production)it.next());
        }
        return grammar;
    }
}

