/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.State;
import automata.Transition;
import automata.fsa.FSAToRegularGrammarConverter;
import automata.fsa.FiniteStateAutomaton;
import grammar.Grammar;
import grammar.Production;
import grammar.reg.RegularGrammar;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.viewer.SelectionDrawer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class FSAConvertController
extends ConvertController {
    private FSAToRegularGrammarConverter converter = new FSAToRegularGrammarConverter();

    public FSAConvertController(ConvertPane pane, SelectionDrawer drawer, FiniteStateAutomaton automaton) {
        super(pane, drawer, automaton);
        this.converter.initializeConverter(automaton);
        this.fillMap();
        State[] states = automaton.getStates();
        int i = 0;
        while (i < states.length) {
            states[i].setLabel(this.converter.variableForState(states[i]));
            ++i;
        }
    }

    @Override
    protected Production[] getProductions(State state) {
        if (!this.getAutomaton().isFinalState(state)) {
            return new Production[0];
        }
        Production[] p = new Production[]{this.converter.getLambdaProductionForFinalState(this.getAutomaton(), state)};
        return p;
    }

    @Override
    protected Production[] getProductions(Transition transition) {
        Production[] p = new Production[]{this.converter.getProductionForTransition(transition)};
        return p;
    }

    @Override
    protected Grammar getGrammar() {
        int rows = this.getModel().getRowCount();
        RegularGrammar grammar = new RegularGrammar();
        grammar.setStartVariable("S");
        ArrayList<Production> productions = new ArrayList<Production>();
        int i = 0;
        while (i < rows) {
            Production production = this.getModel().getProduction(i);
            if (production != null) {
                productions.add(production);
            }
            ++i;
        }
        Collections.sort(productions, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Production p1 = (Production)o1;
                Production p2 = (Production)o2;
                if ("S".equals(p1.getLHS())) {
                    if (p1.getLHS().equals(p2.getLHS())) {
                        return 0;
                    }
                    return -1;
                }
                if ("S".equals(p2.getLHS())) {
                    return 1;
                }
                return p1.getLHS().compareTo(p2.getRHS());
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        Iterator it = productions.iterator();
        while (it.hasNext()) {
            grammar.addProduction((Production)it.next());
        }
        return grammar;
    }
}

