/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.Automaton;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.editor.ArrowDisplayOnlyTool;
import gui.environment.AutomatonEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ConvertPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AutomatonPane automatonPane;
    private GrammarTable table = new GrammarTable(new GrammarTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }
    });
    private SelectionDrawer drawer;

    public ConvertPane(AutomatonEnvironment environment, Automaton automaton) {
        super(new BorderLayout());
        this.drawer = new SelectionDrawer(automaton);
        this.automatonPane = new AutomatonPane(this.drawer);
        JSplitPane split = SplitPaneFactory.createSplit(environment, true, 0.6, this.automatonPane, new JScrollPane(this.table));
        this.automatonPane.addMouseListener(new ArrowDisplayOnlyTool(this.automatonPane, this.automatonPane.getDrawer()));
        this.add((Component)split, "Center");
        this.add((Component)new TableTextSizeSlider(this.table, 0), "South");
    }

    public AutomatonPane getAutomatonPane() {
        return this.automatonPane;
    }

    public SelectionDrawer getDrawer() {
        return this.drawer;
    }

    public GrammarTable getTable() {
        return this.table;
    }
}

