/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.Automaton;
import automata.State;
import automata.Transition;
import grammar.Grammar;
import grammar.Production;
import gui.environment.FrameFactory;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.GrammarCreationException;
import gui.viewer.SelectionDrawer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ConvertController {
    protected HashMap<Serializable, Production[]> objectToProduction = new HashMap();
    protected HashMap<Production, Serializable> productionToObject = new HashMap();
    protected HashSet<Object> alreadyDone = new HashSet();
    protected ConvertPane convertPane;
    private Automaton automaton;
    private SelectionDrawer drawer;
    private GrammarTable table;

    public ConvertController(ConvertPane pane, SelectionDrawer drawer, Automaton automaton) {
        this.convertPane = pane;
        this.automaton = automaton;
        this.table = pane.getTable();
        this.drawer = drawer;
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConvertController.this.changeSelection();
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    protected void changeSelection() {
        model = this.table.getSelectionModel();
        min = model.getMinSelectionIndex();
        max = model.getMaxSelectionIndex();
        this.drawer.clearSelected();
        if (min != -1) ** GOTO lbl14
        this.convertPane.getAutomatonPane().repaint();
        return;
lbl-1000:
        // 1 sources

        {
            if (model.isSelectedIndex(min) && (o = this.productionToObject.get(p = this.table.getGrammarModel().getProduction(min))) != null) {
                if (o instanceof State) {
                    this.drawer.addSelected((State)o);
                } else {
                    this.drawer.addSelected((Transition)o);
                }
            }
            ++min;
lbl14:
            // 2 sources

            ** while (min <= max)
        }
lbl15:
        // 1 sources

        this.convertPane.getAutomatonPane().repaint();
    }

    protected void fillMap() {
        State[] states = this.automaton.getStates();
        int i = 0;
        while (i < states.length) {
            Production[] prods = this.getProductions(states[i]);
            if (prods.length != 0) {
                this.objectToProduction.put(states[i], prods);
                int j = 0;
                while (j < prods.length) {
                    this.productionToObject.put(prods[j], states[i]);
                    ++j;
                }
            }
            ++i;
        }
        Transition[] transitions = this.automaton.getTransitions();
        int i2 = 0;
        while (i2 < transitions.length) {
            Production[] prods = this.getProductions(transitions[i2]);
            if (prods.length != 0) {
                this.objectToProduction.put(transitions[i2], prods);
                int j = 0;
                while (j < prods.length) {
                    this.productionToObject.put(prods[j], transitions[i2]);
                    ++j;
                }
            }
            ++i2;
        }
    }

    private void addProductions(Collection<Production> productions) {
        Iterator<Production> it = productions.iterator();
        if (!it.hasNext()) {
            return;
        }
        GrammarTableModel model = this.table.getGrammarModel();
        int min = 1000000000;
        int max = 0;
        while (it.hasNext()) {
            Production p = it.next();
            int row = model.addProduction(p);
            min = Math.min(min, row);
            max = Math.max(max, row);
        }
        this.table.setRowSelectionInterval(min, max);
    }

    public Production[] revealObjectProductions(Object object) {
        Production[] p = this.objectToProduction.get(object);
        if (p == null || p.length == 0) {
            JOptionPane.showMessageDialog(this.convertPane, "There are no productions for that object!");
            return null;
        }
        if (this.alreadyDone.contains(object)) {
            JOptionPane.showMessageDialog(this.convertPane, "This object has already been converted!");
            return new Production[0];
        }
        this.alreadyDone.add(object);
        this.addProductions(Arrays.asList(p));
        return p;
    }

    public Object revealRandomProductions() {
        for (Map.Entry<Serializable, Production[]> entry : this.objectToProduction.entrySet()) {
            Serializable key = entry.getKey();
            if (this.alreadyDone.contains(key)) continue;
            Production[] p = this.objectToProduction.get(key);
            this.addProductions(Arrays.asList(p));
            this.alreadyDone.add(entry.getKey());
            return key;
        }
        return null;
    }

    public int revealAllProductions() {
        HashSet<Serializable> remaining = new HashSet<Serializable>(this.objectToProduction.keySet());
        remaining.removeAll(this.alreadyDone);
        int number = remaining.size();
        Iterator it = remaining.iterator();
        ArrayList<Production> ps = new ArrayList<Production>();
        while (it.hasNext()) {
            Production[] p = this.objectToProduction.get(it.next());
            ps.addAll(Arrays.asList(p));
        }
        this.addProductions(ps);
        this.alreadyDone.addAll(remaining);
        return number;
    }

    public Object[] highlightUntransformed() {
        HashSet<Serializable> unselectedSet = new HashSet<Serializable>(this.objectToProduction.keySet());
        unselectedSet.removeAll(this.alreadyDone);
        Object[] unselected = unselectedSet.toArray();
        this.drawer.clearSelected();
        int i = 0;
        while (i < unselected.length) {
            if (unselected[i] instanceof State) {
                this.drawer.addSelected((State)unselected[i]);
            } else {
                this.drawer.addSelected((Transition)unselected[i]);
            }
            ++i;
        }
        this.convertPane.getAutomatonPane().repaint();
        return unselected;
    }

    protected abstract Grammar getGrammar();

    public Grammar exportGrammar() {
        if (this.objectToProduction.keySet().size() != this.alreadyDone.size()) {
            this.highlightUntransformed();
            JOptionPane.showMessageDialog(this.convertPane, "Conversion unfinished!  Objects to convert are highlighted.", "Conversion Unfinished", 0);
            this.changeSelection();
            return null;
        }
        try {
            Grammar g = this.getGrammar();
            FrameFactory.createFrame(g);
            return g;
        }
        catch (GrammarCreationException e) {
            JOptionPane.showMessageDialog(this.convertPane, e.getMessage(), "Error", 0);
            return null;
        }
    }

    protected Automaton getAutomaton() {
        return this.automaton;
    }

    protected Production[] getProductions(State state) {
        return new Production[0];
    }

    protected Production[] getProductions(Transition transition) {
        return new Production[0];
    }

    protected GrammarTableModel getModel() {
        return this.table.getGrammarModel();
    }
}

