/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.turing.TMTransition;
import automata.turing.TuringMachine;
import gui.editor.TableTransitionCreator;
import gui.viewer.AutomatonPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TMTransitionCreator
extends TableTransitionCreator {
    private boolean blockTransition = false;
    private TuringMachine machine;
    private static String[] DIRS = new String[]{"R", "S", "L"};
    private static JComboBox<String> BOX = new JComboBox<String>(DIRS);
    private static KeyStroke[] STROKES;
    private static final Action CHANGE_ACTION;

    static {
        CHANGE_ACTION = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                box.setSelectedItem(e.getActionCommand().toUpperCase());
            }
        };
        STROKES = new KeyStroke[DIRS.length];
        int i = 0;
        while (i < STROKES.length) {
            TMTransitionCreator.STROKES[i] = KeyStroke.getKeyStroke("shift " + DIRS[i]);
            ++i;
        }
    }

    public TMTransitionCreator(AutomatonPane parent) {
        super(parent);
        this.machine = (TuringMachine)parent.getDrawer().getAutomaton();
    }

    @Override
    protected Transition initTransition(State from, State to) {
        if (!this.blockTransition) {
            return this.initTransition(from, to, "R");
        }
        return this.initTransition(from, to, "S");
    }

    protected Transition initTransition(State from, State to, String directionString) {
        String[] read = new String[this.machine.tapes()];
        int i = 0;
        while (i < read.length) {
            read[i] = "";
            ++i;
        }
        String[] write = read;
        if (this.blockTransition) {
            write = new String[this.machine.tapes()];
            int i2 = 0;
            while (i2 < write.length) {
                write[i2] = "~";
                ++i2;
            }
        }
        String[] direction = new String[this.machine.tapes()];
        int i3 = 0;
        while (i3 < direction.length) {
            direction[i3] = directionString;
            ++i3;
        }
        TMTransition t = new TMTransition(from, to, read, write, direction);
        t.setBlockTransition(this.blockTransition);
        return t;
    }

    private String[][] arraysForTransition(TMTransition transition) {
        String[][] s = new String[this.machine.tapes()][3];
        int i = this.machine.tapes() - 1;
        while (i >= 0) {
            s[i][0] = transition.getRead(i);
            s[i][1] = transition.getWrite(i);
            if (s[i][0].equals("\u25a1")) {
                s[i][0] = "";
            }
            if (s[i][1].equals("\u25a1")) {
                s[i][1] = "";
            }
            s[i][2] = transition.getDirection(i);
            --i;
        }
        return s;
    }

    @Override
    protected TableModel createModel(Transition transition) {
        TMTransition t = (TMTransition)transition;
        return new AbstractTableModel(t){
            private static final long serialVersionUID = 1L;
            String[][] s;
            String[] name;
            {
                this.s = TMTransitionCreator.this.arraysForTransition(tMTransition);
                this.name = new String[]{"Read", "Write", "Direction"};
            }

            @Override
            public Object getValueAt(int row, int column) {
                return this.s[row][column];
            }

            @Override
            public void setValueAt(Object o, int r, int c) {
                this.s[r][c] = (String)o;
            }

            @Override
            public boolean isCellEditable(int r, int c) {
                if (!TMTransitionCreator.this.blockTransition) {
                    return true;
                }
                return c == 0;
            }

            @Override
            public int getRowCount() {
                return TMTransitionCreator.this.machine.tapes();
            }

            @Override
            public int getColumnCount() {
                if (!TMTransitionCreator.this.blockTransition) {
                    return 3;
                }
                return 1;
            }

            @Override
            public String getColumnName(int c) {
                return this.name[c];
            }
        };
    }

    @Override
    protected JTable createTable(Transition transition) {
        JTable table = super.createTable(transition);
        if (!this.blockTransition) {
            TableColumn directionColumn = table.getColumnModel().getColumn(2);
            directionColumn.setCellEditor(new DefaultCellEditor(BOX){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    JComboBox c = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    InputMap imap = c.getInputMap();
                    ActionMap amap = c.getActionMap();
                    Object o = new Object();
                    amap.put(o, CHANGE_ACTION);
                    int i = 0;
                    while (i < STROKES.length) {
                        imap.put(STROKES[i], o);
                        ++i;
                    }
                    return c;
                }
            });
        }
        return table;
    }

    @Override
    public Transition modifyTransition(Transition transition, TableModel model) {
        TMTransition t = (TMTransition)transition;
        try {
            String[] reads = new String[this.machine.tapes()];
            String[] writes = new String[this.machine.tapes()];
            String[] dirs = new String[this.machine.tapes()];
            int i = 0;
            while (i < this.machine.tapes()) {
                reads[i] = (String)model.getValueAt(i, 0);
                writes[i] = (String)model.getValueAt(i, 1);
                dirs[i] = (String)model.getValueAt(i, 2);
                ++i;
            }
            TMTransition newTrans = new TMTransition(t.getFromState(), t.getToState(), reads, writes, dirs);
            if (transition instanceof TMTransition) {
                TMTransition oldTrans = (TMTransition)transition;
                newTrans.setBlockTransition(oldTrans.isBlockTransition());
            }
            return newTrans;
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
            return null;
        }
    }

    public boolean isBlockTransition() {
        return this.blockTransition;
    }

    public void setBlockTransition(boolean block) {
        this.blockTransition = block;
    }

    public static void setDirs(boolean allowStay) {
        DIRS = allowStay ? new String[]{"R", "S", "L"} : new String[]{"R", "L"};
        STROKES = new KeyStroke[DIRS.length];
        int i = 0;
        while (i < STROKES.length) {
            TMTransitionCreator.STROKES[i] = KeyStroke.getKeyStroke("shift " + DIRS[i]);
            ++i;
        }
        BOX.removeAllItems();
        i = 0;
        while (i < DIRS.length) {
            BOX.addItem(DIRS[i]);
            ++i;
        }
    }
}

